/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.field;

import java.io.IOException;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.IntConsumer;
import java.util.function.LongConsumer;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.solr.analytics.function.field.AnalyticsField;
import org.apache.solr.analytics.util.function.FloatConsumer;
import org.apache.solr.analytics.value.IntValueStream;

public class IntMultiPointField
extends AnalyticsField
implements IntValueStream.CastingIntValueStream {
    private SortedNumericDocValues docValues;
    private int count = 0;
    private int[] values = new int[20];

    public IntMultiPointField(String fieldName) {
        super(fieldName);
    }

    @Override
    public void doSetNextReader(LeafReaderContext context) throws IOException {
        this.docValues = DocValues.getSortedNumeric((LeafReader)context.reader(), (String)this.fieldName);
    }

    @Override
    public void collect(int doc) throws IOException {
        if (this.docValues.advanceExact(doc)) {
            this.count = this.docValues.docValueCount();
            this.resizeEmptyValues(this.count);
            for (int i = 0; i < this.count; ++i) {
                this.values[i] = (int)this.docValues.nextValue();
            }
        } else {
            this.count = 0;
        }
    }

    private void resizeEmptyValues(int count) {
        if (count > this.values.length) {
            this.values = new int[count];
        }
    }

    @Override
    public void streamInts(IntConsumer cons) {
        for (int i = 0; i < this.count; ++i) {
            cons.accept(this.values[i]);
        }
    }

    @Override
    public void streamLongs(LongConsumer cons) {
        this.streamInts(value -> cons.accept(value));
    }

    @Override
    public void streamFloats(FloatConsumer cons) {
        this.streamInts(value -> cons.accept(value));
    }

    @Override
    public void streamDoubles(DoubleConsumer cons) {
        this.streamInts(value -> cons.accept(value));
    }

    @Override
    public void streamStrings(Consumer<String> cons) {
        this.streamInts(value -> cons.accept(Integer.toString(value)));
    }

    @Override
    public void streamObjects(Consumer<Object> cons) {
        this.streamInts(value -> cons.accept(value));
    }
}

