/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.javax.el;

import java.beans.BeanInfo;
import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.shaded.javax.el.ELContext;
import org.apache.hadoop.shaded.javax.el.ELException;
import org.apache.hadoop.shaded.javax.el.ELResolver;
import org.apache.hadoop.shaded.javax.el.ELUtil;
import org.apache.hadoop.shaded.javax.el.PropertyNotFoundException;
import org.apache.hadoop.shaded.javax.el.PropertyNotWritableException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanELResolver
extends ELResolver {
    private boolean isReadOnly;
    private static final int SIZE = 2000;
    private static final Map<Class, BeanProperties> properties = new ConcurrentHashMap<Class, BeanProperties>(2000);
    private static final Map<Class, BeanProperties> properties2 = new ConcurrentHashMap<Class, BeanProperties>(2000);

    public BeanELResolver() {
        this.isReadOnly = false;
    }

    public BeanELResolver(boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
    }

    @Override
    public Class<?> getType(ELContext context, Object base, Object property) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null || property == null) {
            return null;
        }
        BeanProperty bp = this.getBeanProperty(context, base, property);
        context.setPropertyResolved(true);
        return bp.getPropertyType();
    }

    @Override
    public Object getValue(ELContext context, Object base, Object property) {
        Object value;
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null || property == null) {
            return null;
        }
        BeanProperty bp = this.getBeanProperty(context, base, property);
        Method method = bp.getReadMethod();
        if (method == null) {
            throw new PropertyNotFoundException(ELUtil.getExceptionMessageString(context, "propertyNotReadable", new Object[]{base.getClass().getName(), property.toString()}));
        }
        try {
            value = method.invoke(base, new Object[0]);
            context.setPropertyResolved(true);
        }
        catch (ELException ex) {
            throw ex;
        }
        catch (InvocationTargetException ite) {
            throw new ELException(ite.getCause());
        }
        catch (Exception ex) {
            throw new ELException(ex);
        }
        return value;
    }

    @Override
    public void setValue(ELContext context, Object base, Object property, Object val) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null || property == null) {
            return;
        }
        if (this.isReadOnly) {
            throw new PropertyNotWritableException(ELUtil.getExceptionMessageString(context, "resolverNotwritable", new Object[]{base.getClass().getName()}));
        }
        BeanProperty bp = this.getBeanProperty(context, base, property);
        Method method = bp.getWriteMethod();
        if (method == null) {
            throw new PropertyNotWritableException(ELUtil.getExceptionMessageString(context, "propertyNotWritable", new Object[]{base.getClass().getName(), property.toString()}));
        }
        try {
            method.invoke(base, val);
            context.setPropertyResolved(true);
        }
        catch (ELException ex) {
            throw ex;
        }
        catch (InvocationTargetException ite) {
            throw new ELException(ite.getCause());
        }
        catch (Exception ex) {
            if (null == val) {
                val = "null";
            }
            String message = ELUtil.getExceptionMessageString(context, "setPropertyFailed", new Object[]{property.toString(), base.getClass().getName(), val});
            throw new ELException(message, ex);
        }
    }

    @Override
    public boolean isReadOnly(ELContext context, Object base, Object property) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null || property == null) {
            return false;
        }
        context.setPropertyResolved(true);
        if (this.isReadOnly) {
            return true;
        }
        BeanProperty bp = this.getBeanProperty(context, base, property);
        return bp.isReadOnly();
    }

    @Override
    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        if (base == null) {
            return null;
        }
        BeanInfo info = null;
        try {
            info = Introspector.getBeanInfo(base.getClass());
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (info == null) {
            return null;
        }
        ArrayList<PropertyDescriptor> list = new ArrayList<PropertyDescriptor>(info.getPropertyDescriptors().length);
        for (PropertyDescriptor pd : info.getPropertyDescriptors()) {
            pd.setValue("type", pd.getPropertyType());
            pd.setValue("resolvableAtDesignTime", Boolean.TRUE);
            list.add(pd);
        }
        return list.iterator();
    }

    @Override
    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        if (base == null) {
            return null;
        }
        return Object.class;
    }

    private static Method getMethod(Class cl, Method method) {
        if (Modifier.isPublic(cl.getModifiers())) {
            return method;
        }
        Class<?>[] interfaces = cl.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            Class<?> c = interfaces[i];
            Method m4 = null;
            try {
                m4 = c.getMethod(method.getName(), method.getParameterTypes());
                c = m4.getDeclaringClass();
                m4 = BeanELResolver.getMethod(c, m4);
                if (m4 == null) continue;
                return m4;
            }
            catch (NoSuchMethodException ex) {
                // empty catch block
            }
        }
        Class<Object> c = cl.getSuperclass();
        if (c != null) {
            Method m5 = null;
            try {
                m5 = c.getMethod(method.getName(), method.getParameterTypes());
                c = m5.getDeclaringClass();
                m5 = BeanELResolver.getMethod(c, m5);
                if (m5 != null) {
                    return m5;
                }
            }
            catch (NoSuchMethodException ex) {
                // empty catch block
            }
        }
        return null;
    }

    private BeanProperty getBeanProperty(ELContext context, Object base, Object prop) {
        BeanProperty bp;
        String property = prop.toString();
        Class<?> baseClass = base.getClass();
        BeanProperties bps = properties.get(baseClass);
        if (bps == null && (bps = properties2.get(baseClass)) == null) {
            if (properties.size() > 2000) {
                properties2.clear();
                properties2.putAll(properties);
                properties.clear();
            }
            bps = new BeanProperties(baseClass);
            properties.put(baseClass, bps);
        }
        if ((bp = bps.getBeanProperty(property)) == null) {
            throw new PropertyNotFoundException(ELUtil.getExceptionMessageString(context, "propertyNotFound", new Object[]{baseClass.getName(), property}));
        }
        return bp;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class BeanProperties {
        private final Class baseClass;
        private final Map<String, BeanProperty> propertyMap = new HashMap<String, BeanProperty>();

        public BeanProperties(Class<?> baseClass) {
            PropertyDescriptor[] descriptors;
            this.baseClass = baseClass;
            try {
                BeanInfo info = Introspector.getBeanInfo(baseClass);
                descriptors = info.getPropertyDescriptors();
            }
            catch (IntrospectionException ie) {
                throw new ELException(ie);
            }
            for (PropertyDescriptor pd : descriptors) {
                this.propertyMap.put(pd.getName(), new BeanProperty(baseClass, pd));
            }
        }

        public BeanProperty getBeanProperty(String property) {
            return this.propertyMap.get(property);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class BeanProperty {
        private Method readMethod;
        private Method writeMethod;
        private Class baseClass;
        private PropertyDescriptor descriptor;

        public BeanProperty(Class<?> baseClass, PropertyDescriptor descriptor) {
            this.baseClass = baseClass;
            this.descriptor = descriptor;
        }

        public Class getPropertyType() {
            return this.descriptor.getPropertyType();
        }

        public boolean isReadOnly() {
            return this.getWriteMethod() == null;
        }

        public Method getReadMethod() {
            if (this.readMethod == null) {
                this.readMethod = BeanELResolver.getMethod(this.baseClass, this.descriptor.getReadMethod());
            }
            return this.readMethod;
        }

        public Method getWriteMethod() {
            if (this.writeMethod == null) {
                this.writeMethod = BeanELResolver.getMethod(this.baseClass, this.descriptor.getWriteMethod());
            }
            return this.writeMethod;
        }
    }
}

