/*
 * Decompiled with CFR 0.152.
 */
package com.tdunning.math.stats;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public abstract class Histogram
implements Serializable {
    protected long[] counts;
    protected double min;
    protected double max;
    protected double logFactor;
    protected double logOffset;

    public Histogram(double min, double max) {
        this.min = min;
        this.max = max;
    }

    protected void setupBins(double min, double max) {
        int binCount = this.bucketIndex(max) + 1;
        if (binCount > 10000) {
            throw new IllegalArgumentException(String.format("Excessive number of bins %d resulting from min,max = %.2g, %.2g", binCount, min, max));
        }
        this.counts = new long[binCount];
    }

    public void add(double v) {
        int n = this.bucket(v);
        this.counts[n] = this.counts[n] + 1L;
    }

    public double[] getBounds() {
        double[] r = new double[this.counts.length];
        for (int i = 0; i < r.length; ++i) {
            r[i] = this.lowerBound(i);
        }
        return r;
    }

    public long[] getCounts() {
        return this.counts;
    }

    int bucket(double x) {
        if (x <= this.min) {
            return 0;
        }
        if (x >= this.max) {
            return this.counts.length - 1;
        }
        return this.bucketIndex(x);
    }

    protected abstract int bucketIndex(double var1);

    abstract double lowerBound(int var1);

    abstract long[] getCompressedCounts();

    abstract void writeObject(ObjectOutputStream var1) throws IOException;

    abstract void readObject(ObjectInputStream var1) throws IOException;

    abstract void add(Iterable<Histogram> var1);
}

