# sdl2_net cmake project-config input for ./configure scripts

include(FeatureSummary)
set_package_properties(SDL2_net PROPERTIES
    URL "https://www.libsdl.org/projects/SDL_net/"
    DESCRIPTION "SDL_net is an example portable network library for use with SDL."
)

set(SDL2_net_FOUND TRUE)

get_filename_component(prefix "${CMAKE_CURRENT_LIST_DIR}/../../.." ABSOLUTE)
set(exec_prefix "${prefix}")
set(bindir "${exec_prefix}/bin")
set(includedir "${prefix}/include")
set(libdir "${exec_prefix}/lib")
set(_sdl2net_extra_static_libraries ";@PC_LIBS@")
string(STRIP "${_sdl2net_extra_static_libraries}" _sdl2net_extra_static_libraries)

set(_sdl2net_bindir   "${bindir}")
set(_sdl2net_libdir   "${libdir}")
set(_sdl2net_incdir   "${includedir}/SDL2")

# Convert _sdl2net_extra_static_libraries to list and keep only libraries
string(REGEX MATCHALL "(-[lm]([-a-zA-Z0-9._]+))|(-Wl,[^ ]*framework[^ ]*)" _sdl2net_extra_static_libraries "${_sdl2net_extra_static_libraries}")
string(REGEX REPLACE "^-l" "" _sdl2net_extra_static_libraries "${_sdl2net_extra_static_libraries}")
string(REGEX REPLACE ";-l" ";" _sdl2net_extra_static_libraries "${_sdl2net_extra_static_libraries}")

unset(prefix)
unset(exec_prefix)
unset(bindir)
unset(includedir)
unset(libdir)

include(CMakeFindDependencyMacro)

if(NOT TARGET SDL2_net::SDL2_net)
    add_library(SDL2_net::SDL2_net SHARED IMPORTED)
    set_target_properties(SDL2_net::SDL2_net
        PROPERTIES
            INTERFACE_INCLUDE_DIRECTORIES "${_sdl2net_incdir}"
            COMPATIBLE_INTERFACE_BOOL "SDL2_SHARED"
            INTERFACE_SDL2_SHARED "ON"
    )
    if(WIN32)
        set_target_properties(SDL2_net::SDL2_net
            PROPERTIES
                IMPORTED_LOCATION "${_sdl2net_bindir}/SDL2_net.dll"
                IMPORTED_IMPLIB "${_sdl2net_libdir}/${CMAKE_STATIC_LIBRARY_PREFIX}SDL2_net.dll${CMAKE_STATIC_LIBRARY_SUFFIX}"
        )
    else()
        set_target_properties(SDL2_net::SDL2_net
            PROPERTIES
                IMPORTED_LOCATION "${_sdl2net_libdir}/${CMAKE_SHARED_LIBRARY_PREFIX}SDL2_net${CMAKE_SHARED_LIBRARY_SUFFIX}.1.0"
        )
    endif()
endif()

if(NOT TARGET SDL2_net::SDL2_net-static)
    add_library(SDL2_net::SDL2_net-static STATIC IMPORTED)

    set_target_properties(SDL2_net::SDL2_net-static
        PROPERTIES
            INTERFACE_INCLUDE_DIRECTORIES "${_sdl2net_incdir}"
            IMPORTED_LOCATION "${_sdl2net_libdir}/${CMAKE_STATIC_LIBRARY_PREFIX}SDL2_net${CMAKE_STATIC_LIBRARY_SUFFIX}"
            INTERFACE_LINK_LIBRARIES "${_sdl2net_extra_static_libraries}"
    )
endif()

unset(_sdl2net_extra_static_libraries)
unset(_sdl2net_bindir)
unset(_sdl2net_libdir)
unset(_sdl2net_incdir)
