/*
 * Decompiled with CFR 0.152.
 */
package de.escape.quincunx.dxf.reader;

import de.escape.quincunx.dxf.reader.DxfConvertable;
import de.escape.quincunx.dxf.reader.DxfConverter;
import de.escape.quincunx.dxf.reader.DxfENDSEC;
import de.escape.quincunx.dxf.reader.DxfEntity;
import de.escape.quincunx.dxf.reader.DxfEntityCollector;
import de.escape.quincunx.dxf.reader.DxfEntityCounter;
import de.escape.quincunx.dxf.reader.DxfFile;
import java.util.Enumeration;
import java.util.Vector;

public class DxfEntitySet
implements DxfConvertable,
DxfEntityCollector {
    protected Vector entities = new Vector();
    protected DxfEntityCounter counter = new DxfEntityCounter();

    public void convert(DxfConverter converter, DxfFile dxf, Object collector) {
        converter.convert(this, dxf, collector);
    }

    public boolean addEntity(DxfEntity entity) {
        if (entity instanceof DxfENDSEC) {
            return false;
        }
        this.entities.addElement(entity);
        this.counter.add(entity);
        return true;
    }

    public DxfEntity getBlock(String name) {
        Enumeration e = this.entities.elements();
        while (e.hasMoreElements()) {
            DxfEntity ent = (DxfEntity)e.nextElement();
            if (!ent.isBlockNamed(name)) continue;
            return ent;
        }
        return null;
    }

    public final int getNrOfEntities() {
        return this.entities.size();
    }

    public Enumeration getEntities() {
        return this.entities.elements();
    }

    public Enumeration getCollectedEntityTypes() {
        return this.counter.getEntityNames();
    }

    public int getNumberOf(String entType) {
        return this.counter.getCount(entType);
    }

    public DxfEntity getEntity(int index) {
        return (DxfEntity)this.entities.elementAt(index);
    }
}

