/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.android;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import processing.app.Base;
import processing.app.Editor;
import processing.app.RunnerListener;
import processing.app.Sketch;
import processing.app.SketchException;
import processing.mode.android.AndroidBuild;
import processing.mode.android.AndroidEditor;
import processing.mode.android.AndroidRunner;
import processing.mode.android.AndroidSDK;
import processing.mode.android.BadSDKException;
import processing.mode.android.Devices;
import processing.mode.java.JavaMode;

public class AndroidMode
extends JavaMode {
    private AndroidSDK sdk;
    private File coreZipLocation;
    private AndroidRunner runner;
    static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyMMdd.HHmm");

    public AndroidMode(Base base, File folder) {
        super(base, folder);
    }

    public Editor createEditor(Base base, String path, int[] location) {
        try {
            return new AndroidEditor(base, path, location, this);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getTitle() {
        return "Android";
    }

    public File[] getExampleCategoryFolders() {
        return new File[]{new File(this.examplesFolder, "Basics"), new File(this.examplesFolder, "Topics"), new File(this.examplesFolder, "Sensors"), new File(this.examplesFolder, "OpenGL")};
    }

    protected File getCoreZipLocation() {
        if (this.coreZipLocation == null) {
            File debugFile = new File("../../../android/core.zip");
            if (!debugFile.exists() && Base.isMacOS()) {
                debugFile = new File("../../../../../../../android/core.zip");
            }
            if (debugFile.exists()) {
                System.out.println("Using version of core.zip from local SVN checkout.");
                this.coreZipLocation = debugFile;
            }
            this.coreZipLocation = this.getContentFile("android-core.zip");
        }
        return this.coreZipLocation;
    }

    public AndroidSDK loadSDK() throws BadSDKException, IOException {
        if (this.sdk == null) {
            this.sdk = AndroidSDK.load();
        }
        return this.sdk;
    }

    public AndroidSDK getSDK() {
        return this.sdk;
    }

    public static String getDateStamp() {
        return dateFormat.format(new Date());
    }

    public static String getDateStamp(long stamp) {
        return dateFormat.format(new Date(stamp));
    }

    public void handleRunEmulator(Sketch sketch, RunnerListener listener) throws SketchException, IOException {
        listener.startIndeterminate();
        listener.statusNotice("Starting build...");
        AndroidBuild build = new AndroidBuild(sketch, this);
        listener.statusNotice("Building Android project...");
        build.build("debug");
        listener.statusNotice("Running sketch on emulator...");
        this.runner = new AndroidRunner(build, listener);
        this.runner.launch(Devices.getInstance().getEmulator());
    }

    public void handleRunDevice(Sketch sketch, RunnerListener listener) throws SketchException, IOException {
        listener.startIndeterminate();
        listener.statusNotice("Starting build...");
        AndroidBuild build = new AndroidBuild(sketch, this);
        listener.statusNotice("Building Android project...");
        build.build("debug");
        listener.statusNotice("Running sketch on device...");
        this.runner = new AndroidRunner(build, listener);
        this.runner.launch(Devices.getInstance().getHardware());
    }

    public void handleStop(RunnerListener listener) {
        listener.statusNotice("");
        listener.stopIndeterminate();
        if (this.runner != null) {
            this.runner.close();
            this.runner = null;
        }
    }
}

