/* [config]
 * expect_result: pass
 * glsl_version: 3.00
 * [end config]
 *
 * Declare a flat interpolation ivec2 inside a struct.
 *
 * The OpenGL ES Shading Language 3.00 spec states:
 *
 *    "4.3.4 Input Variables
 *    ...
 *        Fragment shader inputs that are, or contain, signed or
 *        unsigned integers or integer vectors must be qualified with
 *        the interpolation qualifier flat."
 */

#version 300 es

precision mediump float;

struct S {
	ivec2 u;
};

flat in S s;
out vec4 color;

void main()
{
	color = vec4(s.u.xyxy);
}
