/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * radians(-180.0) => -3.1415927
 * radians(-60.0) => -1.0471976
 * radians(60.0) => 1.0471976
 * radians(180.0) => 3.1415927
 */
#version 150

void main()
{
  float[distance(radians(-180.0), -3.1415927) <= 3.1415926e-05 ? 1 : -1] array0;
  float[distance(radians(-60.0), -1.0471976) <= 1.0471976e-05 ? 1 : -1] array1;
  float[distance(radians(60.0), 1.0471976) <= 1.0471976e-05 ? 1 : -1] array2;
  float[distance(radians(180.0), 3.1415927) <= 3.1415926e-05 ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
