/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (uvec4(66u, 72u, 87u, 75u) * uvec4(66u, 72u, 87u, 75u)) => uvec4(4356u, 5184u, 7569u, 5625u)
 * (uvec4(66u, 72u, 87u, 75u) * uvec4(24u, 40u, 23u, 74u)) => uvec4(1584u, 2880u, 2001u, 5550u)
 * (uvec4(24u, 40u, 23u, 74u) * uvec4(66u, 72u, 87u, 75u)) => uvec4(1584u, 2880u, 2001u, 5550u)
 * (uvec4(24u, 40u, 23u, 74u) * uvec4(24u, 40u, 23u, 74u)) => uvec4(576u, 1600u, 529u, 5476u)
 */
#version 150

void main()
{
  float[all(equal((uvec4(66u, 72u, 87u, 75u) * uvec4(66u, 72u, 87u, 75u)), uvec4(4356u, 5184u, 7569u, 5625u))) ? 1 : -1] array0;
  float[all(equal((uvec4(66u, 72u, 87u, 75u) * uvec4(24u, 40u, 23u, 74u)), uvec4(1584u, 2880u, 2001u, 5550u))) ? 1 : -1] array1;
  float[all(equal((uvec4(24u, 40u, 23u, 74u) * uvec4(66u, 72u, 87u, 75u)), uvec4(1584u, 2880u, 2001u, 5550u))) ? 1 : -1] array2;
  float[all(equal((uvec4(24u, 40u, 23u, 74u) * uvec4(24u, 40u, 23u, 74u)), uvec4(576u, 1600u, 529u, 5476u))) ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
