/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (uvec2(38u, 35u) * 0u) => uvec2(0u, 0u)
 * (uvec2(38u, 35u) * 6u) => uvec2(228u, 210u)
 * (uvec2(38u, 35u) * 12u) => uvec2(456u, 420u)
 * (uvec2(38u, 35u) * 32u) => uvec2(1216u, 1120u)
 * (uvec2(38u, 35u) * 74u) => uvec2(2812u, 2590u)
 * (uvec2(64u, 9u) * 0u) => uvec2(0u, 0u)
 * (uvec2(64u, 9u) * 6u) => uvec2(384u, 54u)
 * (uvec2(64u, 9u) * 12u) => uvec2(768u, 108u)
 * (uvec2(64u, 9u) * 32u) => uvec2(2048u, 288u)
 * (uvec2(64u, 9u) * 74u) => uvec2(4736u, 666u)
 */
#version 150

void main()
{
  float[all(equal((uvec2(38u, 35u) * 0u), uvec2(0u, 0u))) ? 1 : -1] array0;
  float[all(equal((uvec2(38u, 35u) * 6u), uvec2(228u, 210u))) ? 1 : -1] array1;
  float[all(equal((uvec2(38u, 35u) * 12u), uvec2(456u, 420u))) ? 1 : -1] array2;
  float[all(equal((uvec2(38u, 35u) * 32u), uvec2(1216u, 1120u))) ? 1 : -1] array3;
  float[all(equal((uvec2(38u, 35u) * 74u), uvec2(2812u, 2590u))) ? 1 : -1] array4;
  float[all(equal((uvec2(64u, 9u) * 0u), uvec2(0u, 0u))) ? 1 : -1] array5;
  float[all(equal((uvec2(64u, 9u) * 6u), uvec2(384u, 54u))) ? 1 : -1] array6;
  float[all(equal((uvec2(64u, 9u) * 12u), uvec2(768u, 108u))) ? 1 : -1] array7;
  float[all(equal((uvec2(64u, 9u) * 32u), uvec2(2048u, 288u))) ? 1 : -1] array8;
  float[all(equal((uvec2(64u, 9u) * 74u), uvec2(4736u, 666u))) ? 1 : -1] array9;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length());
}
