/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (0ul % u64vec3(1333333333333333259ul, 85ul, 94ul)) => u64vec3(0ul, 0ul, 0ul)
 * (0ul % u64vec3(167ul, 66ul, 187ul)) => u64vec3(0ul, 0ul, 0ul)
 * (3ul % u64vec3(1333333333333333259ul, 85ul, 94ul)) => u64vec3(3ul, 3ul, 3ul)
 * (3ul % u64vec3(167ul, 66ul, 187ul)) => u64vec3(3ul, 3ul, 3ul)
 * (1192ul % u64vec3(1333333333333333259ul, 85ul, 94ul)) => u64vec3(1192ul, 2ul, 64ul)
 * (1192ul % u64vec3(167ul, 66ul, 187ul)) => u64vec3(23ul, 4ul, 70ul)
 * (1048576ul % u64vec3(1333333333333333259ul, 85ul, 94ul)) => u64vec3(1048576ul, 16ul, 6ul)
 * (1048576ul % u64vec3(167ul, 66ul, 187ul)) => u64vec3(150ul, 34ul, 67ul)
 * (4251475ul % u64vec3(1333333333333333259ul, 85ul, 94ul)) => u64vec3(4251475ul, 30ul, 43ul)
 * (4251475ul % u64vec3(167ul, 66ul, 187ul)) => u64vec3(156ul, 19ul, 30ul)
 * (29852643761ul % u64vec3(1333333333333333259ul, 85ul, 94ul)) => u64vec3(29852643761ul, 56ul, 57ul)
 * (29852643761ul % u64vec3(167ul, 66ul, 187ul)) => u64vec3(146ul, 17ul, 39ul)
 * (4398046511104ul % u64vec3(1333333333333333259ul, 85ul, 94ul)) => u64vec3(4398046511104ul, 4ul, 50ul)
 * (4398046511104ul % u64vec3(167ul, 66ul, 187ul)) => u64vec3(154ul, 4ul, 4ul)
 * (3948976685146ul % u64vec3(1333333333333333259ul, 85ul, 94ul)) => u64vec3(3948976685146ul, 1ul, 48ul)
 * (3948976685146ul % u64vec3(167ul, 66ul, 187ul)) => u64vec3(154ul, 64ul, 86ul)
 * (135763469567146206ul % u64vec3(1333333333333333259ul, 85ul, 94ul)) => u64vec3(135763469567146206ul, 41ul, 56ul)
 * (135763469567146206ul % u64vec3(167ul, 66ul, 187ul)) => u64vec3(139ul, 60ul, 126ul)
 * (11654173250180970009ul % u64vec3(1333333333333333259ul, 85ul, 94ul)) => u64vec3(987506583514303937ul, 4ul, 93ul)
 * (11654173250180970009ul % u64vec3(167ul, 66ul, 187ul)) => u64vec3(41ul, 39ul, 72ul)
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[all(equal((0ul % u64vec3(1333333333333333259ul, 85ul, 94ul)), u64vec3(0ul, 0ul, 0ul))) ? 1 : -1] array0;
  float[all(equal((0ul % u64vec3(167ul, 66ul, 187ul)), u64vec3(0ul, 0ul, 0ul))) ? 1 : -1] array1;
  float[all(equal((3ul % u64vec3(1333333333333333259ul, 85ul, 94ul)), u64vec3(3ul, 3ul, 3ul))) ? 1 : -1] array2;
  float[all(equal((3ul % u64vec3(167ul, 66ul, 187ul)), u64vec3(3ul, 3ul, 3ul))) ? 1 : -1] array3;
  float[all(equal((1192ul % u64vec3(1333333333333333259ul, 85ul, 94ul)), u64vec3(1192ul, 2ul, 64ul))) ? 1 : -1] array4;
  float[all(equal((1192ul % u64vec3(167ul, 66ul, 187ul)), u64vec3(23ul, 4ul, 70ul))) ? 1 : -1] array5;
  float[all(equal((1048576ul % u64vec3(1333333333333333259ul, 85ul, 94ul)), u64vec3(1048576ul, 16ul, 6ul))) ? 1 : -1] array6;
  float[all(equal((1048576ul % u64vec3(167ul, 66ul, 187ul)), u64vec3(150ul, 34ul, 67ul))) ? 1 : -1] array7;
  float[all(equal((4251475ul % u64vec3(1333333333333333259ul, 85ul, 94ul)), u64vec3(4251475ul, 30ul, 43ul))) ? 1 : -1] array8;
  float[all(equal((4251475ul % u64vec3(167ul, 66ul, 187ul)), u64vec3(156ul, 19ul, 30ul))) ? 1 : -1] array9;
  float[all(equal((29852643761ul % u64vec3(1333333333333333259ul, 85ul, 94ul)), u64vec3(29852643761ul, 56ul, 57ul))) ? 1 : -1] array10;
  float[all(equal((29852643761ul % u64vec3(167ul, 66ul, 187ul)), u64vec3(146ul, 17ul, 39ul))) ? 1 : -1] array11;
  float[all(equal((4398046511104ul % u64vec3(1333333333333333259ul, 85ul, 94ul)), u64vec3(4398046511104ul, 4ul, 50ul))) ? 1 : -1] array12;
  float[all(equal((4398046511104ul % u64vec3(167ul, 66ul, 187ul)), u64vec3(154ul, 4ul, 4ul))) ? 1 : -1] array13;
  float[all(equal((3948976685146ul % u64vec3(1333333333333333259ul, 85ul, 94ul)), u64vec3(3948976685146ul, 1ul, 48ul))) ? 1 : -1] array14;
  float[all(equal((3948976685146ul % u64vec3(167ul, 66ul, 187ul)), u64vec3(154ul, 64ul, 86ul))) ? 1 : -1] array15;
  float[all(equal((135763469567146206ul % u64vec3(1333333333333333259ul, 85ul, 94ul)), u64vec3(135763469567146206ul, 41ul, 56ul))) ? 1 : -1] array16;
  float[all(equal((135763469567146206ul % u64vec3(167ul, 66ul, 187ul)), u64vec3(139ul, 60ul, 126ul))) ? 1 : -1] array17;
  float[all(equal((11654173250180970009ul % u64vec3(1333333333333333259ul, 85ul, 94ul)), u64vec3(987506583514303937ul, 4ul, 93ul))) ? 1 : -1] array18;
  float[all(equal((11654173250180970009ul % u64vec3(167ul, 66ul, 187ul)), u64vec3(41ul, 39ul, 72ul))) ? 1 : -1] array19;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length() + array18.length() + array19.length());
}
