/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * require_extensions: GL_ARB_gpu_shader_fp64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * normalize(dvec2(-0.1lf, -1.2lf)) => dvec2(-0.08304547985373997lf, -0.9965457582448796lf)
 * normalize(dvec2(-0.42lf, 0.48lf)) => dvec2(-0.6585046078685182lf, 0.7525766947068779lf)
 */
#version 150
#extension GL_ARB_gpu_shader_fp64 : require

void main()
{
  double[distance(normalize(dvec2(-0.1lf, -1.2lf)), dvec2(-0.08304547985373997lf, -0.9965457582448796lf)) <= 1e-05lf ? 1 : -1] array0;
  double[distance(normalize(dvec2(-0.42lf, 0.48lf)), dvec2(-0.6585046078685182lf, 0.7525766947068779lf)) <= 1e-05lf ? 1 : -1] array1;
  gl_FragColor = vec4(array0.length() + array1.length());
}
