/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * require_extensions: GL_ARB_gpu_shader_fp64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * faceforward(0.0lf, 0.0lf, 0.0lf) => -0.0lf
 * faceforward(0.0lf, 0.0lf, -1.3333333333333333lf) => -0.0lf
 * faceforward(0.0lf, 0.0lf, 0.85lf) => -0.0lf
 * faceforward(0.0lf, -1.3333333333333333lf, 0.0lf) => -0.0lf
 * faceforward(0.0lf, -1.3333333333333333lf, -1.3333333333333333lf) => -0.0lf
 * faceforward(0.0lf, -1.3333333333333333lf, 0.85lf) => 0.0lf
 * faceforward(0.0lf, 0.85lf, 0.0lf) => -0.0lf
 * faceforward(0.0lf, 0.85lf, -1.3333333333333333lf) => 0.0lf
 * faceforward(0.0lf, 0.85lf, 0.85lf) => -0.0lf
 * faceforward(-1.3333333333333333lf, 0.0lf, 0.0lf) => 1.3333333333333333lf
 * faceforward(-1.3333333333333333lf, 0.0lf, -1.3333333333333333lf) => 1.3333333333333333lf
 * faceforward(-1.3333333333333333lf, 0.0lf, 0.85lf) => 1.3333333333333333lf
 * faceforward(-1.3333333333333333lf, -1.3333333333333333lf, 0.0lf) => 1.3333333333333333lf
 * faceforward(-1.3333333333333333lf, -1.3333333333333333lf, -1.3333333333333333lf) => 1.3333333333333333lf
 * faceforward(-1.3333333333333333lf, -1.3333333333333333lf, 0.85lf) => -1.3333333333333333lf
 * faceforward(-1.3333333333333333lf, 0.85lf, 0.0lf) => 1.3333333333333333lf
 * faceforward(-1.3333333333333333lf, 0.85lf, -1.3333333333333333lf) => -1.3333333333333333lf
 * faceforward(-1.3333333333333333lf, 0.85lf, 0.85lf) => 1.3333333333333333lf
 * faceforward(0.85lf, 0.0lf, 0.0lf) => -0.85lf
 * faceforward(0.85lf, 0.0lf, -1.3333333333333333lf) => -0.85lf
 * faceforward(0.85lf, 0.0lf, 0.85lf) => -0.85lf
 * faceforward(0.85lf, -1.3333333333333333lf, 0.0lf) => -0.85lf
 * faceforward(0.85lf, -1.3333333333333333lf, -1.3333333333333333lf) => -0.85lf
 * faceforward(0.85lf, -1.3333333333333333lf, 0.85lf) => 0.85lf
 * faceforward(0.85lf, 0.85lf, 0.0lf) => -0.85lf
 * faceforward(0.85lf, 0.85lf, -1.3333333333333333lf) => 0.85lf
 * faceforward(0.85lf, 0.85lf, 0.85lf) => -0.85lf
 */
#version 150
#extension GL_ARB_gpu_shader_fp64 : require

void main()
{
  double[distance(faceforward(0.0lf, 0.0lf, 0.0lf), -0.0lf) <= 0.0lf ? 1 : -1] array0;
  double[distance(faceforward(0.0lf, 0.0lf, -1.3333333333333333lf), -0.0lf) <= 0.0lf ? 1 : -1] array1;
  double[distance(faceforward(0.0lf, 0.0lf, 0.85lf), -0.0lf) <= 0.0lf ? 1 : -1] array2;
  double[distance(faceforward(0.0lf, -1.3333333333333333lf, 0.0lf), -0.0lf) <= 0.0lf ? 1 : -1] array3;
  double[distance(faceforward(0.0lf, -1.3333333333333333lf, -1.3333333333333333lf), -0.0lf) <= 0.0lf ? 1 : -1] array4;
  double[distance(faceforward(0.0lf, -1.3333333333333333lf, 0.85lf), 0.0lf) <= 0.0lf ? 1 : -1] array5;
  double[distance(faceforward(0.0lf, 0.85lf, 0.0lf), -0.0lf) <= 0.0lf ? 1 : -1] array6;
  double[distance(faceforward(0.0lf, 0.85lf, -1.3333333333333333lf), 0.0lf) <= 0.0lf ? 1 : -1] array7;
  double[distance(faceforward(0.0lf, 0.85lf, 0.85lf), -0.0lf) <= 0.0lf ? 1 : -1] array8;
  double[distance(faceforward(-1.3333333333333333lf, 0.0lf, 0.0lf), 1.3333333333333333lf) <= 1.3333333333333333e-05lf ? 1 : -1] array9;
  double[distance(faceforward(-1.3333333333333333lf, 0.0lf, -1.3333333333333333lf), 1.3333333333333333lf) <= 1.3333333333333333e-05lf ? 1 : -1] array10;
  double[distance(faceforward(-1.3333333333333333lf, 0.0lf, 0.85lf), 1.3333333333333333lf) <= 1.3333333333333333e-05lf ? 1 : -1] array11;
  double[distance(faceforward(-1.3333333333333333lf, -1.3333333333333333lf, 0.0lf), 1.3333333333333333lf) <= 1.3333333333333333e-05lf ? 1 : -1] array12;
  double[distance(faceforward(-1.3333333333333333lf, -1.3333333333333333lf, -1.3333333333333333lf), 1.3333333333333333lf) <= 1.3333333333333333e-05lf ? 1 : -1] array13;
  double[distance(faceforward(-1.3333333333333333lf, -1.3333333333333333lf, 0.85lf), -1.3333333333333333lf) <= 1.3333333333333333e-05lf ? 1 : -1] array14;
  double[distance(faceforward(-1.3333333333333333lf, 0.85lf, 0.0lf), 1.3333333333333333lf) <= 1.3333333333333333e-05lf ? 1 : -1] array15;
  double[distance(faceforward(-1.3333333333333333lf, 0.85lf, -1.3333333333333333lf), -1.3333333333333333lf) <= 1.3333333333333333e-05lf ? 1 : -1] array16;
  double[distance(faceforward(-1.3333333333333333lf, 0.85lf, 0.85lf), 1.3333333333333333lf) <= 1.3333333333333333e-05lf ? 1 : -1] array17;
  double[distance(faceforward(0.85lf, 0.0lf, 0.0lf), -0.85lf) <= 8.5e-06lf ? 1 : -1] array18;
  double[distance(faceforward(0.85lf, 0.0lf, -1.3333333333333333lf), -0.85lf) <= 8.5e-06lf ? 1 : -1] array19;
  double[distance(faceforward(0.85lf, 0.0lf, 0.85lf), -0.85lf) <= 8.5e-06lf ? 1 : -1] array20;
  double[distance(faceforward(0.85lf, -1.3333333333333333lf, 0.0lf), -0.85lf) <= 8.5e-06lf ? 1 : -1] array21;
  double[distance(faceforward(0.85lf, -1.3333333333333333lf, -1.3333333333333333lf), -0.85lf) <= 8.5e-06lf ? 1 : -1] array22;
  double[distance(faceforward(0.85lf, -1.3333333333333333lf, 0.85lf), 0.85lf) <= 8.5e-06lf ? 1 : -1] array23;
  double[distance(faceforward(0.85lf, 0.85lf, 0.0lf), -0.85lf) <= 8.5e-06lf ? 1 : -1] array24;
  double[distance(faceforward(0.85lf, 0.85lf, -1.3333333333333333lf), 0.85lf) <= 8.5e-06lf ? 1 : -1] array25;
  double[distance(faceforward(0.85lf, 0.85lf, 0.85lf), -0.85lf) <= 8.5e-06lf ? 1 : -1] array26;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length() + array18.length() + array19.length() + array20.length() + array21.length() + array22.length() + array23.length() + array24.length() + array25.length() + array26.length());
}
