/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * require_extensions: GL_ARB_gpu_shader_fp64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * equal(dvec2(-1.5lf, -1.5lf), dvec2(-1.5lf, -0.5lf)) => bvec2(true, false)
 * equal(dvec2(-1.5lf, -1.5lf), dvec2(0.5lf, 1.5lf)) => bvec2(false, false)
 * equal(dvec2(-0.5lf, -0.5lf), dvec2(-1.5lf, -0.5lf)) => bvec2(false, true)
 * equal(dvec2(-0.5lf, -0.5lf), dvec2(0.5lf, 1.5lf)) => bvec2(false, false)
 * equal(dvec2(0.5lf, 0.5lf), dvec2(-1.5lf, -0.5lf)) => bvec2(false, false)
 * equal(dvec2(0.5lf, 0.5lf), dvec2(0.5lf, 1.5lf)) => bvec2(true, false)
 * equal(dvec2(1.5lf, 1.5lf), dvec2(-1.5lf, -0.5lf)) => bvec2(false, false)
 * equal(dvec2(1.5lf, 1.5lf), dvec2(0.5lf, 1.5lf)) => bvec2(false, true)
 */
#version 150
#extension GL_ARB_gpu_shader_fp64 : require

void main()
{
  double[equal(dvec2(-1.5lf, -1.5lf), dvec2(-1.5lf, -0.5lf))[0] == true && equal(dvec2(-1.5lf, -1.5lf), dvec2(-1.5lf, -0.5lf))[1] == false ? 1 : -1] array0;
  double[equal(dvec2(-1.5lf, -1.5lf), dvec2(0.5lf, 1.5lf))[0] == false && equal(dvec2(-1.5lf, -1.5lf), dvec2(0.5lf, 1.5lf))[1] == false ? 1 : -1] array1;
  double[equal(dvec2(-0.5lf, -0.5lf), dvec2(-1.5lf, -0.5lf))[0] == false && equal(dvec2(-0.5lf, -0.5lf), dvec2(-1.5lf, -0.5lf))[1] == true ? 1 : -1] array2;
  double[equal(dvec2(-0.5lf, -0.5lf), dvec2(0.5lf, 1.5lf))[0] == false && equal(dvec2(-0.5lf, -0.5lf), dvec2(0.5lf, 1.5lf))[1] == false ? 1 : -1] array3;
  double[equal(dvec2(0.5lf, 0.5lf), dvec2(-1.5lf, -0.5lf))[0] == false && equal(dvec2(0.5lf, 0.5lf), dvec2(-1.5lf, -0.5lf))[1] == false ? 1 : -1] array4;
  double[equal(dvec2(0.5lf, 0.5lf), dvec2(0.5lf, 1.5lf))[0] == true && equal(dvec2(0.5lf, 0.5lf), dvec2(0.5lf, 1.5lf))[1] == false ? 1 : -1] array5;
  double[equal(dvec2(1.5lf, 1.5lf), dvec2(-1.5lf, -0.5lf))[0] == false && equal(dvec2(1.5lf, 1.5lf), dvec2(-1.5lf, -0.5lf))[1] == false ? 1 : -1] array6;
  double[equal(dvec2(1.5lf, 1.5lf), dvec2(0.5lf, 1.5lf))[0] == false && equal(dvec2(1.5lf, 1.5lf), dvec2(0.5lf, 1.5lf))[1] == true ? 1 : -1] array7;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length());
}
