/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.rest.log.internal;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.net.URL;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedDeque;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.io.rest.RESTResource;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JSONRequired;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsApplicationSelect;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsName;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="log")
@Produces(value={"application/json"})
@Tag(name="log")
@Component
@JaxrsResource
@JaxrsName(value="log")
@JaxrsApplicationSelect(value="(osgi.jaxrs.name=openhab)")
@JSONRequired
@NonNullByDefault
public class LogHandler
implements RESTResource {
    private final Logger logger = LoggerFactory.getLogger(LogHandler.class);
    public static final String PATH_LOG = "log";
    private static final String TEMPLATE_INTERNAL_ERROR = "{\"error\":\"%s\",\"severity\":\"%s\"}";
    private final ConcurrentLinkedDeque<LogMessage> logBuffer = new ConcurrentLinkedDeque();

    @GET
    @Path(value="/levels")
    @Operation(operationId="getLogLevels", summary="Get log severities, which are logged by the current logger settings.", responses={@ApiResponse(responseCode="200", description="This depends on the current log settings at the backend.")})
    public Response getLogLevels() {
        return Response.ok(this.createLogLevelsMap()).build();
    }

    @GET
    @Operation(operationId="getLastLogMessagesForFrontend", summary="Returns the last logged frontend messages. The amount is limited to the 500 last entries.")
    public Response getLastLogs(@DefaultValue(value="500") @QueryParam(value="limit") @Parameter(name="limit", schema=@Schema(implementation=Integer.class, minimum="1", maximum="500")) @Nullable Integer limit) {
        if (this.logBuffer.isEmpty()) {
            return Response.ok((Object)"[]").build();
        }
        int effectiveLimit = limit == null || limit <= 0 || limit > 500 ? this.logBuffer.size() : limit.intValue();
        if (effectiveLimit >= this.logBuffer.size()) {
            return Response.ok((Object)this.logBuffer.toArray()).build();
        }
        ArrayList<LogMessage> result = new ArrayList<LogMessage>();
        Iterator<LogMessage> iter = this.logBuffer.descendingIterator();
        do {
            result.add(iter.next());
        } while (iter.hasNext() && result.size() < effectiveLimit);
        Collections.reverse(result);
        return Response.ok(result).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Operation(operationId="logMessageToBackend", summary="Log a frontend log message to the backend.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="403", description="Your log severity is not supported.")})
    public Response log(@Parameter(name="logMessage", description="Severity is required and can be one of error, warn, info or debug, depending on activated severities which you can GET at /logLevels.", example="{\"severity\": \"error\", \"url\": \"http://example.org\", \"message\": \"Error message\"}") @Nullable LogMessage logMessage) {
        if (logMessage == null) {
            this.logger.debug("Received null log message model!");
            return Response.status((int)500).entity((Object)String.format(TEMPLATE_INTERNAL_ERROR, "Internal logging error.", "ERROR")).build();
        }
        logMessage.timestamp = ZonedDateTime.now().toInstant().toEpochMilli();
        if (!this.doLog(logMessage)) {
            return Response.status((int)403).entity((Object)String.format(TEMPLATE_INTERNAL_ERROR, "Your log severity is not supported.", logMessage.severity)).build();
        }
        this.logBuffer.add(logMessage);
        if (this.logBuffer.size() > 500) {
            this.logBuffer.pollLast();
        }
        return Response.ok(null, (String)"text/plain").build();
    }

    private boolean doLog(LogMessage logMessage) {
        String severity = logMessage.severity;
        switch (severity = severity != null ? severity.toLowerCase() : "") {
            case "error": {
                this.logger.error("Frontend Log ({}): {}", (Object)logMessage.url, (Object)logMessage.message);
                break;
            }
            case "warn": {
                this.logger.warn("Frontend Log ({}): {}", (Object)logMessage.url, (Object)logMessage.message);
                break;
            }
            case "info": {
                this.logger.info("Frontend Log ({}): {}", (Object)logMessage.url, (Object)logMessage.message);
                break;
            }
            case "debug": {
                this.logger.debug("Frontend Log ({}): {}", (Object)logMessage.url, (Object)logMessage.message);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private Map<String, Boolean> createLogLevelsMap() {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        result.put("error", this.logger.isErrorEnabled());
        result.put("warn", this.logger.isWarnEnabled());
        result.put("info", this.logger.isInfoEnabled());
        result.put("debug", this.logger.isDebugEnabled());
        return result;
    }

    public static class LogMessage {
        public long timestamp;
        public @Nullable String severity;
        public @Nullable URL url;
        public @Nullable String message;
    }
}

