/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.audio.internal.javasound;

import java.io.IOException;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.TargetDataLine;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.audio.AudioException;
import org.openhab.core.audio.AudioFormat;
import org.openhab.core.audio.AudioSource;
import org.openhab.core.audio.AudioStream;
import org.openhab.core.audio.PipedAudioStream;
import org.openhab.core.audio.internal.javasound.JavaSoundInputStream;
import org.openhab.core.common.ThreadPoolManager;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(service={AudioSource.class}, immediate=true)
public class JavaSoundAudioSource
implements AudioSource {
    private final Logger logger = LoggerFactory.getLogger(JavaSoundAudioSource.class);
    private final javax.sound.sampled.AudioFormat format = new javax.sound.sampled.AudioFormat(16000.0f, 16, 1, true, false);
    private final AudioFormat audioFormat = JavaSoundAudioSource.convertAudioFormat(this.format);
    private @Nullable TargetDataLine microphone;
    private final PipedAudioStream.Group streamGroup = PipedAudioStream.newGroup(this.audioFormat);
    private @Nullable Future<?> pipeWriteTask;
    private final ScheduledExecutorService executor = ThreadPoolManager.getScheduledPool((String)"OH-core-javasound-source");

    private TargetDataLine initMicrophone(javax.sound.sampled.AudioFormat format) throws AudioException {
        try {
            TargetDataLine microphone = AudioSystem.getTargetDataLine(format);
            microphone.open(format);
            return microphone;
        }
        catch (Exception e) {
            throw new AudioException("Error creating the audio input stream: " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AudioStream getInputStream(AudioFormat expectedFormat) throws AudioException {
        if (!expectedFormat.isCompatible(this.audioFormat)) {
            throw new AudioException("Cannot produce streams in format " + String.valueOf(expectedFormat));
        }
        PipedAudioStream.Group group = this.streamGroup;
        synchronized (group) {
            PipedAudioStream audioStream;
            TargetDataLine microphone = this.microphone;
            if (microphone == null) {
                this.microphone = microphone = this.initMicrophone(this.format);
            }
            try {
                audioStream = this.streamGroup.getAudioStreamInGroup();
                audioStream.onClose(() -> {
                    PipedAudioStream.Group group = this.streamGroup;
                    synchronized (group) {
                        if (this.streamGroup.isEmpty()) {
                            TargetDataLine microphoneDataLine;
                            Future<?> pipeWriteTask = this.pipeWriteTask;
                            if (pipeWriteTask != null) {
                                pipeWriteTask.cancel(true);
                                this.pipeWriteTask = null;
                            }
                            if ((microphoneDataLine = this.microphone) != null) {
                                microphoneDataLine.close();
                                this.microphone = null;
                            }
                        }
                    }
                });
            }
            catch (IOException ie) {
                throw new AudioException("Cannot open stream pipe: " + ie.getMessage());
            }
            JavaSoundInputStream inputStream = new JavaSoundInputStream(audioStream, this.audioFormat);
            microphone.start();
            this.startPipeWrite();
            return inputStream;
        }
    }

    private void startPipeWrite() {
        if (this.pipeWriteTask == null) {
            this.pipeWriteTask = this.executor.submit(() -> {
                byte[] buffer = new byte[1024];
                while (!this.streamGroup.isEmpty()) {
                    TargetDataLine stream = this.microphone;
                    if (stream != null) {
                        try {
                            int lengthRead = stream.read(buffer, 0, buffer.length);
                            this.streamGroup.write(buffer, 0, lengthRead);
                            this.streamGroup.flush();
                        }
                        catch (RuntimeException e) {
                            this.logger.warn("RuntimeException while reading from JavaSound source: {}", (Object)e.getMessage());
                        }
                        continue;
                    }
                    this.logger.warn("Unable access to microphone stream");
                }
                this.pipeWriteTask = null;
            });
        }
    }

    public String toString() {
        return "javasound";
    }

    private static AudioFormat convertAudioFormat(javax.sound.sampled.AudioFormat audioFormat) {
        String container = "NONE";
        String codec = audioFormat.getEncoding().toString();
        Boolean bigEndian = audioFormat.isBigEndian();
        int frameSize = audioFormat.getFrameSize();
        int bitsPerFrame = frameSize * 8;
        Integer bitDepth = -1 == frameSize ? null : Integer.valueOf(bitsPerFrame);
        float frameRate = audioFormat.getFrameRate();
        Integer bitRate = -1.0f == frameRate ? null : Integer.valueOf((int)(frameRate * (float)bitsPerFrame));
        float sampleRate = audioFormat.getSampleRate();
        Long frequency = -1.0f == sampleRate ? null : Long.valueOf((long)sampleRate);
        return new AudioFormat(container, codec, bigEndian, bitDepth, bitRate, frequency);
    }

    @Override
    public String getId() {
        return "javasound";
    }

    @Override
    public String getLabel(@Nullable Locale locale) {
        return "System Microphone";
    }

    @Override
    public Set<AudioFormat> getSupportedFormats() {
        return Set.of(this.audioFormat);
    }
}

