/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.internal.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.Action;
import org.openhab.core.automation.Condition;
import org.openhab.core.automation.Trigger;
import org.openhab.core.automation.internal.provider.AbstractResourceBundleProvider;
import org.openhab.core.automation.internal.provider.i18n.ModuleI18nUtil;
import org.openhab.core.automation.internal.provider.i18n.RuleTemplateI18nUtil;
import org.openhab.core.automation.parser.Parser;
import org.openhab.core.automation.template.RuleTemplate;
import org.openhab.core.automation.template.RuleTemplateProvider;
import org.openhab.core.common.registry.Provider;
import org.openhab.core.common.registry.ProviderChangeListener;
import org.openhab.core.config.core.ConfigDescriptionParameter;
import org.openhab.core.config.core.i18n.ConfigI18nLocalizationService;
import org.openhab.core.i18n.TranslationProvider;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@NonNullByDefault
@Component(immediate=true, service={RuleTemplateProvider.class, Provider.class}, property={"provider.type=bundle"})
public class TemplateResourceBundleProvider
extends AbstractResourceBundleProvider<RuleTemplate>
implements RuleTemplateProvider {
    private final RuleTemplateI18nUtil ruleTemplateI18nUtil;
    private final ModuleI18nUtil moduleI18nUtil;

    @Activate
    public TemplateResourceBundleProvider(@Reference ConfigI18nLocalizationService configI18nService, @Reference TranslationProvider i18nProvider) {
        super("OH-INF/automation/templates/");
        this.configI18nService = configI18nService;
        this.ruleTemplateI18nUtil = new RuleTemplateI18nUtil(i18nProvider);
        this.moduleI18nUtil = new ModuleI18nUtil(i18nProvider);
    }

    @Override
    @Activate
    protected void activate(@Nullable BundleContext bundleContext) {
        super.activate(bundleContext);
    }

    @Override
    @Deactivate
    protected void deactivate() {
        super.deactivate();
    }

    @Override
    @Reference(cardinality=ReferenceCardinality.AT_LEAST_ONE, policy=ReferencePolicy.DYNAMIC, target="(parser.type=parser.template)")
    protected void addParser(Parser<RuleTemplate> parser, Map<String, String> properties) {
        super.addParser(parser, properties);
    }

    @Override
    protected void removeParser(Parser<RuleTemplate> parser, Map<String, String> properties) {
        super.removeParser(parser, properties);
    }

    public Collection<RuleTemplate> getAll() {
        return this.providedObjectsHolder.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProviderChangeListener(ProviderChangeListener<RuleTemplate> listener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProviderChangeListener(ProviderChangeListener<RuleTemplate> listener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    @Override
    public @Nullable RuleTemplate getTemplate(String uid, @Nullable Locale locale) {
        return this.getPerLocale((RuleTemplate)this.providedObjectsHolder.get(uid), locale);
    }

    @Override
    public Collection<RuleTemplate> getTemplates(@Nullable Locale locale) {
        ArrayList<RuleTemplate> templatesList = new ArrayList<RuleTemplate>();
        for (RuleTemplate t : this.providedObjectsHolder.values()) {
            RuleTemplate rtPerLocale = this.getPerLocale(t, locale);
            if (rtPerLocale == null) continue;
            templatesList.add(rtPerLocale);
        }
        return templatesList;
    }

    private @Nullable RuleTemplate getPerLocale(@Nullable RuleTemplate defTemplate, @Nullable Locale locale) {
        if (locale == null || defTemplate == null) {
            return defTemplate;
        }
        String uid = defTemplate.getUID();
        Bundle bundle = this.getBundle(uid);
        if (bundle != null && defTemplate instanceof RuleTemplate) {
            String llabel = this.ruleTemplateI18nUtil.getLocalizedRuleTemplateLabel(bundle, uid, defTemplate.getLabel(), locale);
            String ldescription = this.ruleTemplateI18nUtil.getLocalizedRuleTemplateDescription(bundle, uid, defTemplate.getDescription(), locale);
            List<ConfigDescriptionParameter> lconfigDescriptions = this.getLocalizedConfigurationDescription(defTemplate.getConfigurationDescriptions(), bundle, uid, "rule-template", locale);
            List<Action> lactions = this.moduleI18nUtil.getLocalizedModules(defTemplate.getActions(), bundle, uid, "rule-template", locale);
            List<Condition> lconditions = this.moduleI18nUtil.getLocalizedModules(defTemplate.getConditions(), bundle, uid, "rule-template", locale);
            List<Trigger> ltriggers = this.moduleI18nUtil.getLocalizedModules(defTemplate.getTriggers(), bundle, uid, "rule-template", locale);
            return new RuleTemplate(uid, llabel, ldescription, defTemplate.getTags(), ltriggers, lconditions, lactions, lconfigDescriptions, defTemplate.getVisibility());
        }
        return null;
    }

    @Override
    protected String getUID(RuleTemplate parsedObject) {
        return parsedObject.getUID();
    }
}

