/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.internal.module.handler;

import java.time.DayOfWeek;
import java.time.ZonedDateTime;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.automation.Condition;
import org.openhab.core.automation.handler.BaseConditionModuleHandler;
import org.openhab.core.automation.handler.TimeBasedConditionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class DayOfWeekConditionHandler
extends BaseConditionModuleHandler
implements TimeBasedConditionHandler {
    public static final String MODULE_TYPE_ID = "timer.DayOfWeekCondition";
    public static final String MODULE_CONTEXT_NAME = "MODULE";
    public static final String CFG_DAYS = "days";
    private final Logger logger = LoggerFactory.getLogger(DayOfWeekConditionHandler.class);
    private final Set<DayOfWeek> days;

    public DayOfWeekConditionHandler(Condition module) {
        super(module);
        try {
            this.days = new HashSet<DayOfWeek>();
            for (String day : (Iterable)module.getConfiguration().get(CFG_DAYS)) {
                switch (day.toUpperCase()) {
                    case "SUN": {
                        this.days.add(DayOfWeek.SUNDAY);
                        break;
                    }
                    case "MON": {
                        this.days.add(DayOfWeek.MONDAY);
                        break;
                    }
                    case "TUE": {
                        this.days.add(DayOfWeek.TUESDAY);
                        break;
                    }
                    case "WED": {
                        this.days.add(DayOfWeek.WEDNESDAY);
                        break;
                    }
                    case "THU": {
                        this.days.add(DayOfWeek.THURSDAY);
                        break;
                    }
                    case "FRI": {
                        this.days.add(DayOfWeek.FRIDAY);
                        break;
                    }
                    case "SAT": {
                        this.days.add(DayOfWeek.SATURDAY);
                        break;
                    }
                    default: {
                        this.logger.warn("Ignoring illegal weekday '{}'", (Object)day);
                    }
                }
            }
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("'days' parameter must be an array of strings.");
        }
    }

    @Override
    public boolean isSatisfied(Map<String, Object> context) {
        return this.isSatisfiedAt(ZonedDateTime.now());
    }

    @Override
    public boolean isSatisfiedAt(ZonedDateTime time) {
        DayOfWeek dow = time.getDayOfWeek();
        return this.days.contains(dow);
    }
}

