/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.server;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.xtext.ide.server.UriExtensions;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.ILocationInFileProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.LineAndColumn;

@Singleton
public class DocumentExtensions {
    @Inject
    private UriExtensions uriExtensions;
    @Inject
    private ILocationInFileProvider locationInFileProvider;

    public Position newPosition(Resource resource, int offset) {
        if (resource instanceof XtextResource) {
            ICompositeNode rootNode = ((XtextResource)resource).getParseResult().getRootNode();
            LineAndColumn lineAndColumn = NodeModelUtils.getLineAndColumn((INode)rootNode, (int)offset);
            return new Position(lineAndColumn.getLine() - 1, lineAndColumn.getColumn() - 1);
        }
        return null;
    }

    public Range newRange(Resource resource, int startOffset, int endOffset) {
        Position startPosition = this.newPosition(resource, startOffset);
        if (startPosition == null) {
            return null;
        }
        Position endPosition = this.newPosition(resource, endOffset);
        if (endPosition == null) {
            return null;
        }
        return new Range(startPosition, endPosition);
    }

    public Range newRange(Resource resource, ITextRegion region) {
        if (region == null) {
            return null;
        }
        return this.newRange(resource, region.getOffset(), region.getOffset() + region.getLength());
    }

    public Location newLocation(Resource resource, ITextRegion textRegion) {
        Range range = this.newRange(resource, textRegion);
        if (range == null) {
            return null;
        }
        String uri = this.uriExtensions.toUriString(resource.getURI());
        return new Location(uri, range);
    }

    public Location newLocation(EObject object) {
        Resource resource = object.eResource();
        ITextRegion textRegion = this.locationInFileProvider.getSignificantTextRegion(object);
        return this.newLocation(resource, textRegion);
    }

    public Location newFullLocation(EObject object) {
        Resource resource = object.eResource();
        ITextRegion textRegion = this.locationInFileProvider.getFullTextRegion(object);
        return this.newLocation(resource, textRegion);
    }

    public Location newLocation(EObject owner, EStructuralFeature feature, int indexInList) {
        Resource resource = owner.eResource();
        ITextRegion textRegion = this.locationInFileProvider.getSignificantTextRegion(owner, feature, indexInList);
        return this.newLocation(resource, textRegion);
    }
}

