/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.spi.servlet;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleReference;
import org.osgi.framework.wiring.BundleWiring;

public class OsgiServletContextClassLoader
extends ClassLoader
implements BundleReference {
    private List<Bundle> bundles = new ArrayList<Bundle>();

    public OsgiServletContextClassLoader() {
        super(null);
    }

    public Bundle getBundle() {
        return this.bundles.size() == 0 ? null : this.bundles.get(0);
    }

    public void addBundle(Bundle bundle) {
        if (bundle != null && !this.bundles.contains(bundle)) {
            this.bundles.add(bundle);
        }
    }

    public void addBundles(Bundle ... bundle) {
        if (this.bundles != null) {
            for (Bundle b : bundle) {
                if (b == null || this.bundles.contains(b)) continue;
                this.bundles.add(b);
            }
        }
    }

    public List<Bundle> getBundles() {
        return this.bundles;
    }

    public void makeImmutable() {
        this.bundles = Collections.unmodifiableList(this.bundles);
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        ArrayList<Exception> suppressed = new ArrayList<Exception>(this.bundles.size());
        for (Bundle b : this.bundles) {
            BundleWiring bw = (BundleWiring)b.adapt(BundleWiring.class);
            ClassLoader cl = bw == null ? null : bw.getClassLoader();
            if (cl == null) continue;
            try {
                return cl.loadClass(name);
            }
            catch (Exception e) {
                suppressed.add(e);
            }
        }
        ClassNotFoundException cnfe = new ClassNotFoundException(name);
        suppressed.forEach(cnfe::addSuppressed);
        throw cnfe;
    }

    @Override
    protected URL findResource(String name) {
        for (Bundle b : this.bundles) {
            URL res;
            BundleWiring bw = (BundleWiring)b.adapt(BundleWiring.class);
            ClassLoader cl = bw == null ? null : bw.getClassLoader();
            if (cl == null || (res = cl.getResource(name)) == null) continue;
            return res;
        }
        return null;
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        ArrayList<URL> urls = new ArrayList<URL>(32);
        for (Bundle b : this.bundles) {
            Enumeration<URL> e;
            BundleWiring bw = (BundleWiring)b.adapt(BundleWiring.class);
            ClassLoader cl = bw == null ? null : bw.getClassLoader();
            if (cl == null || (e = cl.getResources(name)) == null) continue;
            while (e.hasMoreElements()) {
                urls.add(e.nextElement());
            }
        }
        return Collections.enumeration(urls);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        throw new ClassNotFoundException(name);
    }
}

