/*
 * Decompiled with CFR 0.152.
 */
package io.methvin.watchservice;

import io.methvin.watchservice.AbstractWatchKey;
import io.methvin.watchservice.WatchablePath;
import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Collections;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

abstract class AbstractWatchService
implements WatchService {
    private final BlockingQueue<WatchKey> queue = new LinkedBlockingQueue<WatchKey>();
    private final WatchKey poison = new AbstractWatchKey(this, null, Collections.emptySet(), 1);
    private final AtomicBoolean open = new AtomicBoolean(true);

    AbstractWatchService() {
    }

    public abstract AbstractWatchKey register(WatchablePath var1, Iterable<? extends WatchEvent.Kind<?>> var2) throws IOException;

    public boolean isOpen() {
        return this.open.get();
    }

    final void enqueue(AbstractWatchKey abstractWatchKey) {
        if (this.isOpen()) {
            this.queue.add(abstractWatchKey);
        }
    }

    public void cancelled(AbstractWatchKey abstractWatchKey) {
    }

    @Override
    public WatchKey poll() {
        this.checkOpen();
        return this.check((WatchKey)this.queue.poll());
    }

    @Override
    public WatchKey poll(long l, TimeUnit timeUnit) throws InterruptedException {
        this.checkOpen();
        return this.check(this.queue.poll(l, timeUnit));
    }

    @Override
    public WatchKey take() throws InterruptedException {
        this.checkOpen();
        return this.check(this.queue.take());
    }

    private WatchKey check(WatchKey watchKey) {
        if (watchKey == this.poison) {
            this.queue.offer(this.poison);
            throw new ClosedWatchServiceException();
        }
        return watchKey;
    }

    protected final void checkOpen() {
        if (!this.open.get()) {
            throw new ClosedWatchServiceException();
        }
    }

    @Override
    public void close() {
        if (this.open.compareAndSet(true, false)) {
            this.queue.clear();
            this.queue.offer(this.poison);
        }
    }

    static final class Event<T>
    implements WatchEvent<T> {
        private final WatchEvent.Kind<T> kind;
        private final int count;
        private final T context;

        public Event(WatchEvent.Kind<T> kind, int n, T t) {
            this.kind = Objects.requireNonNull(kind);
            if (n < 0) {
                throw new IllegalArgumentException(String.format("count (%s) must be non-negative", n));
            }
            this.count = n;
            this.context = t;
        }

        @Override
        public WatchEvent.Kind<T> kind() {
            return this.kind;
        }

        @Override
        public int count() {
            return this.count;
        }

        @Override
        public T context() {
            return this.context;
        }

        public boolean equals(Object object) {
            if (object instanceof Event) {
                Event event = (Event)object;
                return this.kind().equals(event.kind()) && this.count() == event.count() && Objects.equals(this.context(), event.context());
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.kind(), this.count(), this.context());
        }

        public String toString() {
            return new StringJoiner(", ", this.getClass().getSimpleName() + "[", "]").add("kind=" + this.kind()).add("count=" + this.count()).add("context=" + this.context()).toString();
        }
    }
}

