/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.xtext;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.access.IJvmTypeProvider;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.impl.AbstractScope;

public abstract class AbstractTypeScope
extends AbstractScope {
    private final IJvmTypeProvider typeProvider;
    private final IQualifiedNameConverter qualifiedNameConverter;
    private final Predicate<IEObjectDescription> filter;

    protected AbstractTypeScope(IJvmTypeProvider typeProvider, IQualifiedNameConverter qualifiedNameConverter, Predicate<IEObjectDescription> filter) {
        super(IScope.NULLSCOPE, false);
        this.typeProvider = typeProvider;
        this.qualifiedNameConverter = qualifiedNameConverter;
        this.filter = filter;
    }

    public IEObjectDescription getSingleElement(QualifiedName name) {
        return this.getSingleElement(name, false);
    }

    public IEObjectDescription getSingleElement(QualifiedName name, boolean binary) {
        IEObjectDescription result;
        block5: {
            JvmType type;
            block4: {
                try {
                    type = this.typeProvider.findTypeByName(this.qualifiedNameConverter.toString(name), binary);
                    if (type != null) break block4;
                    return null;
                }
                catch (IllegalArgumentException e) {
                    return null;
                }
            }
            result = EObjectDescription.create((QualifiedName)name, (EObject)type);
            if (this.filter == null || this.filter.apply((Object)result)) break block5;
            return null;
        }
        return result;
    }

    public Iterable<IEObjectDescription> getElements(QualifiedName name) {
        IEObjectDescription result = this.getSingleElement(name);
        if (result != null) {
            return Collections.singleton(result);
        }
        return Collections.emptySet();
    }

    public Iterable<IEObjectDescription> getElements(EObject object) {
        if (object instanceof JvmIdentifiableElement) {
            JvmIdentifiableElement identifiable = (JvmIdentifiableElement)object;
            String qualifiedNameWithDots = identifiable.getQualifiedName('.');
            String qualifiedNameWithDollar = identifiable.getQualifiedName();
            if (qualifiedNameWithDollar.equals(qualifiedNameWithDots)) {
                Set<IEObjectDescription> result = Collections.singleton(EObjectDescription.create((QualifiedName)this.qualifiedNameConverter.toQualifiedName(qualifiedNameWithDots), (EObject)object));
                return this.filterResult(result);
            }
            return this.filterResult(Arrays.asList(EObjectDescription.create((QualifiedName)this.qualifiedNameConverter.toQualifiedName(qualifiedNameWithDots), (EObject)object), EObjectDescription.create((QualifiedName)this.qualifiedNameConverter.toQualifiedName(qualifiedNameWithDollar), (EObject)object)));
        }
        return Collections.emptySet();
    }

    protected Iterable<IEObjectDescription> filterResult(Iterable<IEObjectDescription> unfiltered) {
        if (this.filter == null) {
            return unfiltered;
        }
        return Iterables.filter(unfiltered, this.filter);
    }

    public Iterable<IEObjectDescription> getAllElements() {
        return this.filterResult(this.internalGetAllElements());
    }

    protected Iterable<IEObjectDescription> internalGetAllElements() {
        throw new UnsupportedOperationException();
    }

    protected Iterable<IEObjectDescription> getAllLocalElements() {
        throw new UnsupportedOperationException();
    }

    public IJvmTypeProvider getTypeProvider() {
        return this.typeProvider;
    }

    public IQualifiedNameConverter getQualifiedNameConverter() {
        return this.qualifiedNameConverter;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }
}

