/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.model.types;

import org.jupnp.model.types.AbstractDatatype;
import org.jupnp.model.types.InvalidValueException;
import org.jupnp.util.io.HexBin;

public class BinHexDatatype
extends AbstractDatatype<byte[]> {
    @Override
    public Class<byte[]> getValueType() {
        return byte[].class;
    }

    @Override
    public byte[] valueOf(String s) throws InvalidValueException {
        if (s.isEmpty()) {
            return null;
        }
        try {
            return HexBin.stringToBytes(s);
        }
        catch (Exception e) {
            throw new InvalidValueException(e.getMessage(), e);
        }
    }

    @Override
    public String getString(byte[] value) throws InvalidValueException {
        if (value == null) {
            return "";
        }
        try {
            return HexBin.bytesToString(value);
        }
        catch (Exception e) {
            throw new InvalidValueException(e.getMessage(), e);
        }
    }
}

