/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.model.meta;

import java.util.ArrayList;
import java.util.List;
import org.jupnp.model.Validatable;
import org.jupnp.model.ValidationError;
import org.jupnp.util.SpecificationViolationReporter;

public class StateVariableAllowedValueRange
implements Validatable {
    private final long minimum;
    private final long maximum;
    private final long step;

    public StateVariableAllowedValueRange(long minimum, long maximum) {
        this(minimum, maximum, 1L);
    }

    public StateVariableAllowedValueRange(long minimum, long maximum, long step) {
        if (minimum > maximum) {
            SpecificationViolationReporter.report("Allowed value range minimum '{}' is greater than maximum '{}', switching values.", minimum, maximum);
            this.minimum = maximum;
            this.maximum = minimum;
        } else {
            this.minimum = minimum;
            this.maximum = maximum;
        }
        this.step = step;
    }

    public long getMinimum() {
        return this.minimum;
    }

    public long getMaximum() {
        return this.maximum;
    }

    public long getStep() {
        return this.step;
    }

    public boolean isInRange(long value) {
        return value >= this.getMinimum() && value <= this.getMaximum() && value % this.step == 0L;
    }

    @Override
    public List<ValidationError> validate() {
        return new ArrayList<ValidationError>();
    }

    public String toString() {
        return "Range Min: " + this.getMinimum() + " Max: " + this.getMaximum() + " Step: " + this.getStep();
    }
}

