/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.model.meta;

import java.util.ArrayList;
import java.util.List;
import org.jupnp.model.ModelUtil;
import org.jupnp.model.Validatable;
import org.jupnp.model.ValidationError;
import org.jupnp.model.meta.ActionArgument;
import org.jupnp.model.meta.Service;
import org.jupnp.util.SpecificationViolationReporter;

public class Action<S extends Service>
implements Validatable {
    private final String name;
    private final ActionArgument[] arguments;
    private final ActionArgument[] inputArguments;
    private final ActionArgument[] outputArguments;
    private S service;

    public Action(String name, ActionArgument[] arguments) {
        this.name = name;
        if (arguments != null) {
            ArrayList<ActionArgument> inputList = new ArrayList<ActionArgument>();
            ArrayList<ActionArgument> outputList = new ArrayList<ActionArgument>();
            for (ActionArgument argument : arguments) {
                argument.setAction(this);
                if (argument.getDirection().equals((Object)ActionArgument.Direction.IN)) {
                    inputList.add(argument);
                }
                if (!argument.getDirection().equals((Object)ActionArgument.Direction.OUT)) continue;
                outputList.add(argument);
            }
            this.arguments = arguments;
            this.inputArguments = inputList.toArray(new ActionArgument[inputList.size()]);
            this.outputArguments = outputList.toArray(new ActionArgument[outputList.size()]);
        } else {
            this.arguments = new ActionArgument[0];
            this.inputArguments = new ActionArgument[0];
            this.outputArguments = new ActionArgument[0];
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean hasArguments() {
        return this.getArguments() != null && this.getArguments().length > 0;
    }

    public ActionArgument[] getArguments() {
        return this.arguments;
    }

    public S getService() {
        return this.service;
    }

    void setService(S service) {
        if (this.service != null) {
            throw new IllegalStateException("Final value has been set already, model is immutable");
        }
        this.service = service;
    }

    public ActionArgument<S> getFirstInputArgument() {
        if (!this.hasInputArguments()) {
            throw new IllegalStateException("No input arguments: " + String.valueOf(this));
        }
        return this.getInputArguments()[0];
    }

    public ActionArgument<S> getFirstOutputArgument() {
        if (!this.hasOutputArguments()) {
            throw new IllegalStateException("No output arguments: " + String.valueOf(this));
        }
        return this.getOutputArguments()[0];
    }

    public ActionArgument<S>[] getInputArguments() {
        return this.inputArguments;
    }

    public ActionArgument<S> getInputArgument(String name) {
        for (ActionArgument<S> arg : this.getInputArguments()) {
            if (!arg.isNameOrAlias(name)) continue;
            return arg;
        }
        return null;
    }

    public ActionArgument<S>[] getOutputArguments() {
        return this.outputArguments;
    }

    public ActionArgument<S> getOutputArgument(String name) {
        for (ActionArgument<S> arg : this.getOutputArguments()) {
            if (!arg.getName().equals(name)) continue;
            return arg;
        }
        return null;
    }

    public boolean hasInputArguments() {
        return this.getInputArguments() != null && this.getInputArguments().length > 0;
    }

    public boolean hasOutputArguments() {
        return this.getOutputArguments() != null && this.getOutputArguments().length > 0;
    }

    public String toString() {
        return "(" + this.getClass().getSimpleName() + ", Arguments: " + String.valueOf(this.getArguments() != null ? Integer.valueOf(this.getArguments().length) : "NO ARGS") + ") " + this.getName();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<ValidationError> validate() {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        if (this.getName() == null || this.getName().isEmpty()) {
            errors.add(new ValidationError(this.getClass(), "name", "Action without name of: " + String.valueOf(this.getService())));
        } else if (!ModelUtil.isValidUDAName(this.getName())) {
            SpecificationViolationReporter.report(((Service)this.getService()).getDevice(), "Invalid action name: {}", new Object[]{this});
        }
        for (ActionArgument actionArgument : this.getArguments()) {
            if (((Service)this.getService()).getStateVariable(actionArgument.getRelatedStateVariableName()) != null) continue;
            errors.add(new ValidationError(this.getClass(), "arguments", "Action argument references an unknown state variable: " + actionArgument.getRelatedStateVariableName()));
        }
        ActionArgument retValueArgument = null;
        int retValueArgumentIndex = 0;
        int i = 0;
        for (ActionArgument actionArgument : this.getArguments()) {
            if (actionArgument.isReturnValue()) {
                if (actionArgument.getDirection() == ActionArgument.Direction.IN) {
                    SpecificationViolationReporter.report(((Service)this.getService()).getDevice(), "Input argument can not have <retval/>", new Object[0]);
                } else {
                    if (retValueArgument != null) {
                        SpecificationViolationReporter.report(((Service)this.getService()).getDevice(), "Only one argument of action '{}' can be <retval/>", new Object[]{this.getName()});
                    }
                    retValueArgument = actionArgument;
                    retValueArgumentIndex = i;
                }
            }
            ++i;
        }
        if (retValueArgument != null) {
            void var5_8;
            boolean bl = false;
            while (var5_8 < retValueArgumentIndex) {
                ActionArgument a = this.getArguments()[var5_8];
                if (a.getDirection() == ActionArgument.Direction.OUT) {
                    SpecificationViolationReporter.report(((Service)this.getService()).getDevice(), "Argument '{}' of action '{}' is <retval/> but not the first OUT argument", new Object[]{retValueArgument.getName(), this.getName()});
                }
                ++var5_8;
            }
        }
        for (ActionArgument argument : this.arguments) {
            errors.addAll(argument.validate());
        }
        return errors;
    }

    public Action<S> deepCopy() {
        ActionArgument[] actionArgumentsDupe = new ActionArgument[this.getArguments().length];
        for (int i = 0; i < this.getArguments().length; ++i) {
            ActionArgument arg = this.getArguments()[i];
            actionArgumentsDupe[i] = arg.deepCopy();
        }
        return new Action<S>(this.getName(), actionArgumentsDupe);
    }
}

