/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.controlpoint;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.jupnp.UpnpServiceConfiguration;
import org.jupnp.controlpoint.ActionCallback;
import org.jupnp.controlpoint.ControlPoint;
import org.jupnp.controlpoint.SubscriptionCallback;
import org.jupnp.controlpoint.event.ExecuteAction;
import org.jupnp.controlpoint.event.Search;
import org.jupnp.model.message.header.MXHeader;
import org.jupnp.model.message.header.STAllHeader;
import org.jupnp.model.message.header.UpnpHeader;
import org.jupnp.protocol.ProtocolFactory;
import org.jupnp.registry.Registry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControlPointImpl
implements ControlPoint {
    private final Logger logger = LoggerFactory.getLogger(ControlPointImpl.class);
    protected UpnpServiceConfiguration configuration;
    protected ProtocolFactory protocolFactory;
    protected Registry registry;

    protected ControlPointImpl() {
    }

    public ControlPointImpl(UpnpServiceConfiguration configuration, ProtocolFactory protocolFactory, Registry registry) {
        this.logger.trace("Creating ControlPoint: {}", (Object)this.getClass().getName());
        this.configuration = configuration;
        this.protocolFactory = protocolFactory;
        this.registry = registry;
    }

    @Override
    public UpnpServiceConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public ProtocolFactory getProtocolFactory() {
        return this.protocolFactory;
    }

    @Override
    public Registry getRegistry() {
        return this.registry;
    }

    public void search(Search search) {
        this.search(search.getSearchType(), search.getMxSeconds());
    }

    @Override
    public void search() {
        this.search(new STAllHeader(), MXHeader.DEFAULT_VALUE);
    }

    @Override
    public void search(UpnpHeader searchType) {
        this.search(searchType, MXHeader.DEFAULT_VALUE);
    }

    @Override
    public void search(int mxSeconds) {
        this.search(new STAllHeader(), mxSeconds);
    }

    @Override
    public void search(UpnpHeader searchType, int mxSeconds) {
        this.logger.trace("Sending asynchronous search for: {}", (Object)searchType.getString());
        this.getConfiguration().getAsyncProtocolExecutor().execute(this.getProtocolFactory().createSendingSearch(searchType, mxSeconds));
    }

    public void execute(ExecuteAction executeAction) {
        this.execute(executeAction.getCallback());
    }

    @Override
    public Future execute(ActionCallback callback) {
        this.logger.trace("Invoking action in background: {}", (Object)callback);
        callback.setControlPoint(this);
        ExecutorService executor = this.getConfiguration().getSyncProtocolExecutorService();
        return executor.submit(callback);
    }

    @Override
    public void execute(SubscriptionCallback callback) {
        this.logger.trace("Invoking subscription in background: {}", (Object)callback);
        callback.setControlPoint(this);
        this.getConfiguration().getSyncProtocolExecutorService().execute(callback);
    }
}

