/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.transform;

import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.common.registry.AbstractManagedProvider;
import org.openhab.core.common.registry.Identifiable;
import org.openhab.core.storage.StorageService;
import org.openhab.core.transform.Transformation;
import org.openhab.core.transform.TransformationProvider;
import org.openhab.core.transform.TransformationRegistry;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@NonNullByDefault
@Component(service={TransformationProvider.class, ManagedTransformationProvider.class}, immediate=true)
public class ManagedTransformationProvider
extends AbstractManagedProvider<Transformation, String, PersistedTransformation>
implements TransformationProvider {
    @Activate
    public ManagedTransformationProvider(@Reference StorageService storageService) {
        super(storageService);
    }

    protected String getStorageName() {
        return Transformation.class.getName();
    }

    protected String keyToString(String key) {
        return key;
    }

    protected @Nullable Transformation toElement(String key, PersistedTransformation persistableElement) {
        return new Transformation(persistableElement.uid, persistableElement.label, persistableElement.type, persistableElement.configuration);
    }

    protected PersistedTransformation toPersistableElement(Transformation element) {
        return new PersistedTransformation(element);
    }

    public void add(Transformation element) {
        ManagedTransformationProvider.checkConfiguration(element);
        super.add((Identifiable)element);
    }

    public @Nullable Transformation update(Transformation element) {
        ManagedTransformationProvider.checkConfiguration(element);
        return (Transformation)super.update((Identifiable)element);
    }

    private static void checkConfiguration(Transformation element) {
        Matcher matcher = TransformationRegistry.CONFIG_UID_PATTERN.matcher(element.getUID());
        if (!matcher.matches()) {
            throw new IllegalArgumentException("The transformation configuration UID '" + element.getUID() + "' is invalid.");
        }
        if (!Objects.equals(element.getType(), matcher.group("type"))) {
            throw new IllegalArgumentException("The transformation configuration UID '" + element.getUID() + "' is not matching the type '" + element.getType() + "'.");
        }
    }

    public static class PersistedTransformation {
        @NonNullByDefault(value={})
        public String uid;
        @NonNullByDefault(value={})
        public String label;
        @NonNullByDefault(value={})
        public String type;
        @NonNullByDefault(value={})
        public Map<String, String> configuration;

        protected PersistedTransformation() {
        }

        public PersistedTransformation(Transformation configuration) {
            this.uid = configuration.getUID();
            this.label = configuration.getLabel();
            this.type = configuration.getType();
            this.configuration = configuration.getConfiguration();
        }
    }
}

