/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.common.registry;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.common.registry.Provider;
import org.openhab.core.common.registry.ProviderChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public abstract class AbstractProvider<@NonNull E>
implements Provider<E> {
    private Logger logger = LoggerFactory.getLogger(AbstractProvider.class);
    protected List<ProviderChangeListener<E>> listeners = new CopyOnWriteArrayList<ProviderChangeListener<E>>();

    @Override
    public void addProviderChangeListener(ProviderChangeListener<E> listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeProviderChangeListener(ProviderChangeListener<E> listener) {
        this.listeners.remove(listener);
    }

    private void notifyListeners(@Nullable E oldElement, E element, EventType eventType) {
        for (ProviderChangeListener<E> listener : this.listeners) {
            try {
                switch (eventType) {
                    case ADDED: {
                        listener.added(this, element);
                        break;
                    }
                    case REMOVED: {
                        listener.removed(this, element);
                        break;
                    }
                    case UPDATED: {
                        listener.updated(this, oldElement != null ? oldElement : element, element);
                        break;
                    }
                }
            }
            catch (Exception ex) {
                this.logger.error("Could not inform the listener '{}' about the '{}' event!: {}", new Object[]{listener, eventType.name(), ex.getMessage(), ex});
            }
        }
    }

    private void notifyListeners(E element, EventType eventType) {
        this.notifyListeners(null, element, eventType);
    }

    protected void notifyListenersAboutAddedElement(E element) {
        this.notifyListeners(element, EventType.ADDED);
    }

    protected void notifyListenersAboutRemovedElement(E element) {
        this.notifyListeners(element, EventType.REMOVED);
    }

    protected void notifyListenersAboutUpdatedElement(E oldElement, E element) {
        this.notifyListeners(oldElement, element, EventType.UPDATED);
    }

    private static enum EventType {
        ADDED,
        REMOVED,
        UPDATED;

    }
}

