/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.osgi.eclipse;

import aQute.bnd.build.Project;
import aQute.lib.io.IO;
import aQute.lib.tag.Tag;
import java.io.File;
import java.net.URI;

public class EclipseUtil {
    public static String getClasspath(Project model) throws Exception {
        Tag classpath = new Tag("classpath", new Object[0]);
        String target = model.getProperty("javac.target", "1.8");
        Tag vm = new Tag(classpath, "classpathentry", new Object[0]);
        vm.addAttribute("kind", "con");
        vm.addAttribute("path", "org.eclipse.jdt.launching.JRE_CONTAINER/org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType/JavaSE-" + target);
        Tag bnd = new Tag(classpath, "classpathentry", new Object[0]);
        bnd.addAttribute("kind", "con");
        bnd.addAttribute("path", "aQute.bnd.classpath.container");
        for (File s : model.getSourcePath()) {
            Tag srctag = new Tag(classpath, "classpathentry", new Object[0]);
            srctag.addAttribute("kind", "src");
            srctag.addAttribute("output", EclipseUtil.relative(model, model.getOutput()));
            srctag.addAttribute("path", EclipseUtil.relative(model, s));
            if (s.getName().contains("gen")) {
                Tag attributes = new Tag(srctag, "attributes", new Object[0]);
                Tag attribute = new Tag(attributes, "attribute", new Object[0]);
                attribute.addAttribute("name", "ignore_optional_problems");
                attribute.addAttribute("value", "true");
            }
            IO.mkdirs(s);
        }
        File testSrc = model.getTestSrc();
        if (testSrc != null && testSrc.isDirectory() && testSrc.list().length > 0) {
            Tag tsttag = new Tag(classpath, "classpathentry", new Object[0]);
            tsttag.addAttribute("kind", "src");
            tsttag.addAttribute("output", EclipseUtil.relative(model, model.getTestOutput()));
            tsttag.addAttribute("path", EclipseUtil.relative(model, model.getTestSrc()));
            Tag attributes = new Tag(tsttag, "attributes", new Object[0]);
            Tag attribute = new Tag(attributes, "attribute", new Object[0]);
            attribute.addAttribute("name", "test");
            attribute.addAttribute("value", "true");
        }
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" + classpath.toString();
    }

    public static void createClasspath(Project model) throws Exception {
        String b;
        String classpath = EclipseUtil.getClasspath(model);
        File classpathFile = model.getFile(".classpath");
        String a = classpath.toString();
        String string = b = classpathFile.isFile() ? IO.collect(classpathFile) : "<>";
        if (!a.equals(b)) {
            IO.store((Object)classpath.toString(), classpathFile);
        }
    }

    private static String relative(Project model, File output) {
        URI target = output.toURI();
        URI base = model.getBase().toURI();
        return base.relativize(target).toString();
    }

    public static void fixDirectories(Project model) throws Exception {
        for (File s : model.getSourcePath()) {
            IO.mkdirs(s);
        }
        IO.mkdirs(model.getTestSrc());
    }

    public static void createProject(Project model) throws Exception {
        String b;
        String project = EclipseUtil.getProjectDescription(model);
        File projectFile = model.getFile(".project");
        String a = project.toString();
        String string = b = projectFile.isFile() ? IO.collect(projectFile) : "<>";
        if (!a.equals(b)) {
            IO.store((Object)project, projectFile);
        }
    }

    public static String getProjectDescription(Project model) {
        Tag projectDescription = new Tag("projectDescription", new Object[0]);
        new Tag(projectDescription, "name", (Object)model.getName());
        new Tag(projectDescription, "comment", (Object)"automatically created on import");
        new Tag(projectDescription, "projects", new Object[0]);
        Tag buildSpec = new Tag(projectDescription, "buildSpec", new Object[0]);
        EclipseUtil.buildCommand(buildSpec, "org.eclipse.jdt.core.javabuilder");
        EclipseUtil.buildCommand(buildSpec, "bndtools.core.bndbuilder");
        Tag natures = new Tag(projectDescription, "natures", new Object[0]);
        new Tag(natures, "nature", (Object)"org.eclipse.jdt.core.javanature");
        new Tag(natures, "nature", (Object)"bndtools.core.bndnature");
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" + projectDescription.toString();
    }

    private static void buildCommand(Tag buildSpec, String string) {
        Tag buildCommand = new Tag(buildSpec, "buildCommand", new Object[0]);
        new Tag(buildCommand, "name", (Object)string);
        new Tag(buildCommand, "arguments", new Object[0]);
    }
}

