/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.component;

import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Descriptors;
import aQute.lib.collections.MultiMap;
import aQute.lib.tag.Tag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PropertyDef {
    static final String MARKER = new String("|marker");
    private static final Pattern PROPERTY_PATTERN = Pattern.compile("\\s*(?<key>[^=\\s:]+)\\s*(?::\\s*(?<type>Boolean|Byte|Character|Short|Integer|Long|Float|Double|String)\\s*)?=(?<value>.*)");
    private final Analyzer analyzer;
    private final MultiMap<String, String> property = new MultiMap();
    private final Map<String, String> propertyType = new HashMap<String, String>();

    PropertyDef(Analyzer analyzer) {
        this.analyzer = Objects.requireNonNull(analyzer);
    }

    boolean isEmpty() {
        return this.property.isEmpty();
    }

    boolean containsKey(String key) {
        return this.property.containsKey(key);
    }

    PropertyDef setProperty(String key, String type, List<String> values) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(type);
        if (!values.isEmpty()) {
            this.property.put(key, values);
            this.propertyType.put(key, type);
        }
        return this;
    }

    PropertyDef setProperty(String key, String type, String ... values) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(type);
        if (PropertyDef.notEmpty(values)) {
            ArrayList list = new ArrayList(values.length);
            Collections.addAll(list, values);
            this.property.put(key, list);
            this.propertyType.put(key, type);
        }
        return this;
    }

    PropertyDef addProperty(String key, String type, String ... values) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(type);
        if (PropertyDef.notEmpty(values)) {
            this.property.addAll(key, Arrays.asList(values));
            this.propertyType.put(key, type);
        }
        return this;
    }

    PropertyDef setTypedProperty(Descriptors.TypeRef className, String ... props) {
        if (PropertyDef.notEmpty(props)) {
            MultiMap<String, String> map = new MultiMap<String, String>();
            for (String p : props) {
                Matcher m = PROPERTY_PATTERN.matcher(p);
                if (m.matches()) {
                    String key = m.group("key");
                    String type = m.group("type");
                    if (type == null) {
                        type = "String";
                    }
                    this.propertyType.put(key, type);
                    String value = m.group("value");
                    map.add(key, value);
                    continue;
                }
                this.analyzer.error("Malformed property '%s' on component: %s", p, className);
            }
            this.property.putAll((Map<String, List<String>>)map);
        }
        return this;
    }

    private static boolean notEmpty(Object[] array) {
        return array != null && array.length > 0;
    }

    PropertyDef addAll(PropertyDef propertyDef) {
        this.property.putAll((Map<String, List<String>>)propertyDef.property);
        this.propertyType.putAll(propertyDef.propertyType);
        return this;
    }

    PropertyDef addAll(Collection<PropertyDef> propertyDefs) {
        propertyDefs.forEach(this::addAll);
        return this;
    }

    PropertyDef copy(Function<String, String> keyMapper) {
        PropertyDef copy = new PropertyDef(this.analyzer);
        this.property.keySet().forEach(key -> copy.setProperty((String)keyMapper.apply((String)key), this.propertyType.get(key), (List<String>)this.property.get(key)));
        return copy;
    }

    Stream<Tag> propertyTags(String element) {
        return this.property.keySet().stream().map(name -> {
            Tag tag = new Tag(element, new Object[0]).addAttribute("name", (String)name);
            String type = this.propertyType.get(name);
            tag.addAttribute("type", type);
            Object values = this.property.get(name);
            switch (values.size()) {
                case 0: {
                    return null;
                }
                case 1: {
                    tag.addAttribute("value", this.check(type, (String)values.get(0)));
                    break;
                }
                default: {
                    tag.addContent(values.stream().filter(v -> v != MARKER).map(v -> this.check(type, (String)v)).collect(Collectors.joining("\n")));
                }
            }
            return tag;
        }).filter(Objects::nonNull);
    }

    private String check(String type, String v) {
        if (type == null || type.equals("String")) {
            return v;
        }
        v = v.trim();
        try {
            switch (type) {
                case "Boolean": {
                    Boolean.valueOf(v);
                    break;
                }
                case "Byte": {
                    Byte.valueOf(v);
                    break;
                }
                case "Char": 
                case "Character": {
                    v = Integer.toString(v.charAt(0));
                    break;
                }
                case "Short": {
                    Short.valueOf(v);
                    break;
                }
                case "Integer": {
                    Integer.valueOf(v);
                    break;
                }
                case "Long": {
                    Long.valueOf(v);
                    break;
                }
                case "Float": {
                    Float.valueOf(v);
                    break;
                }
                case "Double": {
                    Double.valueOf(v);
                    break;
                }
                default: {
                    this.analyzer.error("Invalid data type %s", type);
                    break;
                }
            }
        }
        catch (NumberFormatException e) {
            this.analyzer.error("Not a valid number %s for %s, %s", v, type, e.getMessage());
        }
        catch (Throwable e) {
            this.analyzer.error("Cannot convert data %s to type %s", v, type);
        }
        return v;
    }

    public String toString() {
        Iterator<Map.Entry<String, List<String>>> i = this.property.entrySet().iterator();
        if (!i.hasNext()) {
            return "{}";
        }
        StringBuilder b = new StringBuilder().append('{');
        while (true) {
            Map.Entry<String, List<String>> e = i.next();
            String key = e.getKey();
            b.append(key);
            String type = this.propertyType.get(key);
            if (!type.equals("String")) {
                b.append(':').append(type);
            }
            b.append('=').append(e.getValue());
            if (!i.hasNext()) {
                return b.append('}').toString();
            }
            b.append(',').append(' ');
        }
    }
}

