/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.classfile;

import aQute.bnd.classfile.Attribute;
import aQute.bnd.classfile.ClassFile;
import aQute.bnd.classfile.ConstantPool;
import aQute.lib.io.IO;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;

public class UnrecognizedAttribute
implements Attribute {
    public final String name;
    public final ByteBuffer value;

    public UnrecognizedAttribute(String name, ByteBuffer value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String name() {
        return this.name;
    }

    public String toString() {
        return this.name();
    }

    public static UnrecognizedAttribute read(DataInput in, String name, int attribute_length) throws IOException {
        if (attribute_length < 0) {
            throw new IOException("attribute length > 2Gb");
        }
        ByteBuffer value = ClassFile.slice(in, attribute_length);
        return new UnrecognizedAttribute(name, value);
    }

    @Override
    public void write(DataOutput out, ConstantPool constant_pool) throws IOException {
        int attribute_name_index = constant_pool.utf8Info(this.name());
        int attribute_length = this.attribute_length();
        out.writeShort(attribute_name_index);
        out.writeInt(attribute_length);
        ByteBuffer duplicate = this.value.duplicate();
        duplicate.rewind();
        IO.copy(duplicate, out);
    }

    @Override
    public int attribute_length() {
        int attribute_length = this.value.limit();
        return attribute_length;
    }
}

