/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4j.jsonrpc.json;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lsp4j.jsonrpc.JsonRpcException;
import org.eclipse.lsp4j.jsonrpc.MessageConsumer;
import org.eclipse.lsp4j.jsonrpc.MessageIssueException;
import org.eclipse.lsp4j.jsonrpc.MessageIssueHandler;
import org.eclipse.lsp4j.jsonrpc.MessageProducer;
import org.eclipse.lsp4j.jsonrpc.json.MessageConstants;
import org.eclipse.lsp4j.jsonrpc.json.MessageJsonHandler;
import org.eclipse.lsp4j.jsonrpc.messages.Message;
import org.eclipse.lsp4j.jsonrpc.util.LimitedInputStream;

public class StreamMessageProducer
implements MessageProducer,
Closeable,
MessageConstants {
    private static final Logger LOG = Logger.getLogger(StreamMessageProducer.class.getName());
    private final MessageJsonHandler jsonHandler;
    private final MessageIssueHandler issueHandler;
    private InputStream input;
    private MessageConsumer callback;
    private boolean keepRunning;

    public StreamMessageProducer(InputStream input, MessageJsonHandler jsonHandler) {
        this(input, jsonHandler, null);
    }

    public StreamMessageProducer(InputStream input, MessageJsonHandler jsonHandler, MessageIssueHandler issueHandler) {
        this.input = input;
        this.jsonHandler = jsonHandler;
        this.issueHandler = issueHandler;
    }

    public InputStream getInput() {
        return this.input;
    }

    public void setInput(InputStream input) {
        this.input = input;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void listen(MessageConsumer callback) {
        block19: {
            if (this.keepRunning) {
                throw new IllegalStateException("This StreamMessageProducer is already running.");
            }
            this.keepRunning = true;
            this.callback = callback;
            try {
                StringBuilder headerBuilder = null;
                StringBuilder debugBuilder = null;
                boolean newLine = false;
                Headers headers = new Headers();
                while (this.keepRunning) {
                    int c = this.input.read();
                    if (c == -1) {
                        this.keepRunning = false;
                        continue;
                    }
                    if (debugBuilder == null) {
                        debugBuilder = new StringBuilder();
                    }
                    debugBuilder.append((char)c);
                    if (c == 10) {
                        if (newLine) {
                            if (headers.contentLength < 0) {
                                this.fireError(new IllegalStateException("Missing header Content-Length in input \"" + debugBuilder + "\""));
                            } else {
                                boolean result = this.handleMessage(this.input, headers);
                                if (!result) {
                                    this.keepRunning = false;
                                }
                                newLine = false;
                            }
                            headers = new Headers();
                            debugBuilder = null;
                        } else if (headerBuilder != null) {
                            this.parseHeader(headerBuilder.toString(), headers);
                            headerBuilder = null;
                        }
                        newLine = true;
                        continue;
                    }
                    if (c == 13) continue;
                    if (headerBuilder == null) {
                        headerBuilder = new StringBuilder();
                    }
                    headerBuilder.append((char)c);
                    newLine = false;
                }
            }
            catch (IOException exception) {
                if (JsonRpcException.indicatesStreamClosed(exception)) {
                    if (this.keepRunning) {
                        this.fireStreamClosed(exception);
                    }
                    break block19;
                }
                throw new JsonRpcException(exception);
            }
            finally {
                this.callback = null;
                this.keepRunning = false;
            }
        }
    }

    protected void fireError(Throwable error) {
        String message = error.getMessage() != null ? error.getMessage() : "An error occurred while processing an incoming message.";
        LOG.log(Level.SEVERE, message, error);
    }

    protected void fireStreamClosed(Exception cause) {
        String message = cause.getMessage() != null ? cause.getMessage() : "The input stream was closed.";
        LOG.log(Level.INFO, message, cause);
    }

    protected void parseHeader(String line, Headers headers) {
        int sepIndex = line.indexOf(58);
        if (sepIndex >= 0) {
            String key;
            switch (key = line.substring(0, sepIndex).trim()) {
                case "Content-Length": {
                    try {
                        headers.contentLength = Integer.parseInt(line.substring(sepIndex + 1).trim());
                    }
                    catch (NumberFormatException e) {
                        this.fireError(e);
                    }
                    break;
                }
                case "Content-Type": {
                    int charsetIndex = line.indexOf("charset=");
                    if (charsetIndex < 0) break;
                    headers.charset = line.substring(charsetIndex + 8).trim();
                    break;
                }
            }
        }
    }

    protected boolean handleMessage(InputStream input, Headers headers) throws IOException {
        block11: {
            if (this.callback == null) {
                this.callback = message -> LOG.log(Level.INFO, "Received message: " + message);
            }
            try {
                try (InputStreamReader content = new InputStreamReader((InputStream)new LimitedInputStream(input, headers.contentLength, false), headers.charset);){
                    Message message2 = this.jsonHandler.parseMessage(content);
                    this.callback.consume(message2);
                }
                catch (MessageIssueException exception) {
                    if (this.issueHandler != null) {
                        this.issueHandler.handle(exception.getRpcMessage(), exception.getIssues());
                        break block11;
                    }
                    this.fireError(exception);
                }
            }
            catch (Exception exception) {
                this.fireError(exception);
            }
        }
        return true;
    }

    @Override
    public void close() {
        this.keepRunning = false;
    }

    protected static class Headers {
        public int contentLength = -1;
        public String charset = StandardCharsets.UTF_8.name();

        protected Headers() {
        }
    }
}

