/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jax.rs.whiteboard.internal.cxf;

import org.apache.aries.component.dsl.CachingServiceReference;
import org.apache.aries.jax.rs.whiteboard.internal.cxf.ServiceReferenceResourceProvider;
import org.apache.aries.jax.rs.whiteboard.internal.utils.Utils;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.message.Message;
import org.osgi.framework.ServiceObjects;

public class PrototypeServiceReferenceResourceProvider
implements ResourceProvider,
ServiceReferenceResourceProvider {
    private static final String _MESSAGE_INSTANCE_KEY_PREFIX = "org.apache.aries.jax.rs.whiteboard.internal.cxf.PrototypeServiceReferenceResourceProvider.";
    private final String _messageKey;
    private Class<?> _serviceClass;
    private final ServiceObjects<?> _serviceObjects;
    private CachingServiceReference<?> _serviceReference;

    public PrototypeServiceReferenceResourceProvider(CachingServiceReference<?> serviceReference, Class<?> serviceClass, ServiceObjects<?> serviceObjects) {
        this._serviceReference = serviceReference;
        this._serviceClass = serviceClass;
        this._serviceObjects = serviceObjects;
        this._messageKey = _MESSAGE_INSTANCE_KEY_PREFIX + this._serviceClass;
    }

    public Object getInstance(Message m) {
        Object object = m.get((Object)this._messageKey);
        if (object != null) {
            return object;
        }
        if (this.isAvailable()) {
            Object service = this._serviceObjects.getService();
            m.put((Object)this._messageKey, service);
            return service;
        }
        return null;
    }

    public void releaseInstance(Message m, Object o) {
        this._serviceObjects.ungetService(o);
        m.remove((Object)this._messageKey);
    }

    public Class<?> getResourceClass() {
        return this._serviceClass;
    }

    public boolean isSingleton() {
        return false;
    }

    @Override
    public CachingServiceReference<?> getImmutableServiceReference() {
        return this._serviceReference;
    }

    public boolean isAvailable() {
        return Utils.isAvailable(this._serviceObjects.getServiceReference());
    }
}

