<?php

/**
 * This is a single action class, totally inspired by
 * https://medium.com/@remi_collin/keeping-your-laravel-applications-dry-with-single-action-classes-6a950ec54d1d.
 */

namespace App\Services\Contact\Conversation;

use App\Services\BaseService;
use App\Models\Contact\Contact;
use App\Models\Contact\Conversation;
use App\Models\Contact\ContactFieldType;

class CreateConversation extends BaseService
{
    /**
     * Get the validation rules that apply to the service.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'happened_at' => 'required|date',
            'account_id' => 'required|integer|exists:accounts,id',
            'contact_id' => 'required|integer|exists:contacts,id',
            'contact_field_type_id' => 'required|integer|exists:contact_field_types,id',
        ];
    }

    /**
     * Create a conversation.
     *
     * @param  array  $data
     * @return Conversation
     */
    public function execute(array $data): Conversation
    {
        $this->validate($data);

        $contact = Contact::where('account_id', $data['account_id'])
                ->findOrFail($data['contact_id']);

        $contact->throwInactive();

        ContactFieldType::where('account_id', $data['account_id'])
                        ->findOrFail($data['contact_field_type_id']);

        return Conversation::create($data);
    }
}
