/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.twiki;

import Acme.JPM.Encoders.GifEncoder;
import Acme.JPM.Encoders.ImageEncoder;
import CH.ifa.draw.appframe.Application;
import CH.ifa.draw.appframe.DrawFrame;
import CH.ifa.draw.contrib.PolygonTool;
import CH.ifa.draw.figures.BorderTool;
import CH.ifa.draw.figures.ConnectedTextTool;
import CH.ifa.draw.figures.ElbowConnection;
import CH.ifa.draw.figures.EllipseFigure;
import CH.ifa.draw.figures.GroupCommand;
import CH.ifa.draw.figures.LineConnection;
import CH.ifa.draw.figures.LineFigure;
import CH.ifa.draw.figures.RectangleFigure;
import CH.ifa.draw.figures.RoundRectangleFigure;
import CH.ifa.draw.figures.ScribbleTool;
import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.figures.TextTool;
import CH.ifa.draw.figures.URLTool;
import CH.ifa.draw.figures.UngroupCommand;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.standard.AbstractTool;
import CH.ifa.draw.standard.AlignCommand;
import CH.ifa.draw.standard.BringToFrontCommand;
import CH.ifa.draw.standard.ChangeAttributeCommand;
import CH.ifa.draw.standard.ConnectionTool;
import CH.ifa.draw.standard.CopyCommand;
import CH.ifa.draw.standard.CreationTool;
import CH.ifa.draw.standard.CutCommand;
import CH.ifa.draw.standard.DeleteCommand;
import CH.ifa.draw.standard.DuplicateCommand;
import CH.ifa.draw.standard.PasteCommand;
import CH.ifa.draw.standard.SendToBackCommand;
import CH.ifa.draw.standard.ToggleGuidesCommand;
import CH.ifa.draw.twiki.TWikiDraw;
import CH.ifa.draw.util.Command;
import CH.ifa.draw.util.CommandButton;
import CH.ifa.draw.util.CommandMenu;
import CH.ifa.draw.util.StorableOutput;
import com.keypoint.PngEncoderIndexed;
import java.awt.Button;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.MenuBar;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;

public class TWikiFrame
extends DrawFrame {
    private static String UNTITLED_PARAMETER = "untitled";
    private static String DRAWPATH_PARAMETER = "drawpath";
    private static String GIFPATH_PARAMETER = "gifpath";
    private static String PNGPATH_PARAMETER = "pngpath";
    private static String SVGPATH_PARAMETER = "svgpath";
    private static String SAVEPATH_PARAMETER = "savepath";
    private static String BASENAME_PARAMETER = "basename";
    private static String HELPPATH_PARAMETER = "helppath";
    private static String BORDERSIZE_PARAMETER = "bordersize";
    private Label fStatusLabel;

    public TWikiFrame(Application application) {
        super("TWikiDraw", application);
        this.view().setBackground(Color.white);
        if (application.getParameter(DRAWPATH_PARAMETER) != null) {
            this.loadDrawing(DRAWPATH_PARAMETER);
        }
    }

    protected void populateMenuBar(MenuBar menuBar) {
        menuBar.add(this.createDrawingMenu());
        menuBar.add(this.createEditMenu());
        menuBar.add(this.createSelectionMenu());
        menuBar.add(this.createFillMenu());
        menuBar.add(this.createLineMenu());
        menuBar.add(this.createTextMenu());
        this.setMenuBar(menuBar);
    }

    protected CommandMenu createDrawingMenu() {
        CommandMenu commandMenu = new CommandMenu("Drawing");
        commandMenu.add(new NewDrawingCommand(this));
        commandMenu.add(new ReloadDrawingCommand(this));
        commandMenu.add(new SaveDrawingCommand(this));
        commandMenu.add(new ExitDrawingCommand(this));
        return commandMenu;
    }

    protected CommandMenu createEditMenu() {
        CommandMenu commandMenu = new CommandMenu("Edit");
        commandMenu.add(new DeleteCommand("Delete", this.view()));
        commandMenu.add(new CutCommand("Cut", this.view()));
        commandMenu.add(new CopyCommand("Copy", this.view()));
        commandMenu.add(new PasteCommand("Paste", this.view()));
        commandMenu.add(new ToggleGuidesCommand("Toggle guides", this.view()));
        return commandMenu;
    }

    protected CommandMenu createSelectionMenu() {
        CommandMenu commandMenu = new CommandMenu("Selection");
        commandMenu.add(new DuplicateCommand("Duplicate", this.view()));
        commandMenu.add(new GroupCommand("Group", this.view()));
        commandMenu.add(new UngroupCommand("Ungroup", this.view()));
        commandMenu.add(new SendToBackCommand("Send to Back", this.view()));
        commandMenu.add(new BringToFrontCommand("Bring to Front", this.view()));
        CommandMenu commandMenu2 = new CommandMenu("Align");
        commandMenu2.add(new AlignCommand("Lefts", this.view(), 0));
        commandMenu2.add(new AlignCommand("Centres", this.view(), 1));
        commandMenu2.add(new AlignCommand("Rights", this.view(), 2));
        commandMenu2.add(new AlignCommand("Tops", this.view(), 3));
        commandMenu2.add(new AlignCommand("Middles", this.view(), 4));
        commandMenu2.add(new AlignCommand("Bottoms", this.view(), 5));
        commandMenu.add(commandMenu2);
        return commandMenu;
    }

    protected CommandMenu createFillMenu() {
        CommandMenu commandMenu = new CommandMenu("Fill");
        commandMenu.add(this.createColorMenu("FillColor"));
        return commandMenu;
    }

    protected CommandMenu createLineMenu() {
        CommandMenu commandMenu = new CommandMenu("Line");
        commandMenu.add(this.createColorMenu("FrameColor"));
        CommandMenu commandMenu2 = new CommandMenu("Arrows");
        commandMenu2.add(new ChangeAttributeCommand("none", "ArrowMode", new Integer(0), this.view()));
        commandMenu2.add(new ChangeAttributeCommand("at Start", "ArrowMode", new Integer(1), this.view()));
        commandMenu2.add(new ChangeAttributeCommand("at End", "ArrowMode", new Integer(2), this.view()));
        commandMenu2.add(new ChangeAttributeCommand("at Both ends", "ArrowMode", new Integer(3), this.view()));
        commandMenu.add(commandMenu2);
        return commandMenu;
    }

    protected CommandMenu createTextMenu() {
        CommandMenu commandMenu = new CommandMenu("Text");
        commandMenu.add(this.createFontMenu());
        commandMenu.add(this.createColorMenu("TextColor"));
        CommandMenu commandMenu2 = new CommandMenu("Style");
        commandMenu2.add(new ChangeAttributeCommand("Plain", "FontStyle", new Integer(0), this.view()));
        commandMenu2.add(new ChangeAttributeCommand("Italic", "FontStyle", new Integer(2), this.view()));
        commandMenu2.add(new ChangeAttributeCommand("Bold", "FontStyle", new Integer(1), this.view()));
        commandMenu.add(commandMenu2);
        CommandMenu commandMenu3 = new CommandMenu("Align");
        commandMenu3.add(new ChangeAttributeCommand("Left", "TextAlign", "Left", this.view()));
        commandMenu3.add(new ChangeAttributeCommand("Centre", "TextAlign", "Centre", this.view()));
        commandMenu3.add(new ChangeAttributeCommand("Right", "TextAlign", "Right", this.view()));
        commandMenu.add(commandMenu3);
        return commandMenu;
    }

    protected void populateWestPanel(Panel panel) {
        super.populateWestPanel(panel);
        AbstractTool abstractTool = new TextTool(this.view(), new TextFigure());
        panel.add(this.createToolButton("/CH/ifa/draw/images/TEXT", "Text Tool", abstractTool));
        abstractTool = new ConnectedTextTool(this.view(), new TextFigure());
        panel.add(this.createToolButton("/CH/ifa/draw/images/ATEXT", "Connected Text Tool", abstractTool));
        abstractTool = new CreationTool(this.view(), new RectangleFigure());
        panel.add(this.createToolButton("/CH/ifa/draw/images/RECT", "Rectangle Tool", abstractTool));
        abstractTool = new CreationTool(this.view(), new RoundRectangleFigure());
        panel.add(this.createToolButton("/CH/ifa/draw/images/RRECT", "Round Rectangle Tool", abstractTool));
        abstractTool = new CreationTool(this.view(), new EllipseFigure());
        panel.add(this.createToolButton("/CH/ifa/draw/images/ELLIPSE", "Ellipse Tool", abstractTool));
        abstractTool = new CreationTool(this.view(), new LineFigure());
        panel.add(this.createToolButton("/CH/ifa/draw/images/LINE", "Line Tool", abstractTool));
        abstractTool = new ConnectionTool(this.view(), new LineConnection());
        panel.add(this.createToolButton("/CH/ifa/draw/images/CONN", "Connection Tool", abstractTool));
        abstractTool = new ConnectionTool(this.view(), new ElbowConnection());
        panel.add(this.createToolButton("/CH/ifa/draw/images/OCONN", "Elbow Connection Tool", abstractTool));
        abstractTool = new ScribbleTool(this.view());
        panel.add(this.createToolButton("/CH/ifa/draw/images/SCRIBBL", "Scribble Tool", abstractTool));
        abstractTool = new PolygonTool(this.view());
        panel.add(this.createToolButton("/CH/ifa/draw/images/POLYGON", "Polygon Tool", abstractTool));
        abstractTool = new BorderTool(this.view());
        panel.add(this.createToolButton("/CH/ifa/draw/images/BORDDEC", "Border Tool", abstractTool));
        abstractTool = new URLTool(this.view(), new RectangleFigure());
        panel.add(this.createToolButton("/CH/ifa/draw/images/URL", "URL Tool", abstractTool));
    }

    protected Panel createSouthPanel() {
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(2, 1));
        return panel;
    }

    protected void populateSouthPanel(Panel panel) {
        Panel panel2 = new Panel();
        Button button = new CommandButton(new DeleteCommand("Delete", this.view()));
        panel2.add(button);
        button = new CommandButton(new DuplicateCommand("Duplicate", this.view()));
        panel2.add(button);
        button = new CommandButton(new GroupCommand("Group", this.view()));
        panel2.add(button);
        button = new CommandButton(new UngroupCommand("Ungroup", this.view()));
        panel2.add(button);
        button = new CommandButton(new BringToFrontCommand("Bring To Front", this.view()));
        panel2.add(button);
        button = new CommandButton(new SendToBackCommand("Send To Back", this.view()));
        panel2.add(button);
        button = new Button("Help");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TWikiFrame.this.showHelp();
            }
        });
        panel2.add(button);
        panel.add(panel2);
        this.fStatusLabel = new Label("Status");
        panel.add(this.fStatusLabel);
    }

    public void showStatus(String string) {
        if (this.fStatusLabel != null) {
            this.fStatusLabel.setText(string);
        } else {
            this.getApplication().showStatus(string);
        }
    }

    protected void setSimpleDisplayUpdate() {
    }

    protected void setBufferedDisplayUpdate() {
    }

    protected void showHelp() {
        try {
            String string = this.getApplication().getParameter(HELPPATH_PARAMETER);
            if (string != null) {
                URL uRL = this.getApplication().getURL(string);
                this.getApplication().popupFrame(uRL, "Help");
            }
        }
        catch (IOException iOException) {
            this.showStatus("Help file not found");
        }
    }

    public void doLoadDrawing(String string) {
        this.loadDrawing(string);
        this.view().setBackground(Color.white);
    }

    public boolean doSaveDrawing() {
        TWikiDraw tWikiDraw = (TWikiDraw)this.getApplication();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        this.setCursor(new Cursor(3));
        try {
            String string;
            String string2;
            String string3;
            Object object;
            String string4;
            String string5;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            StorableOutput storableOutput = new StorableOutput(byteArrayOutputStream);
            storableOutput.writeStorable(this.drawing());
            storableOutput.close();
            String string6 = tWikiDraw.getParameter(DRAWPATH_PARAMETER);
            if (string6 == null) {
                string6 = "untitled.draw";
            }
            if ((string5 = tWikiDraw.getParameter(SAVEPATH_PARAMETER)) == null) {
                string5 = "";
            }
            if ((string4 = tWikiDraw.getParameter(BASENAME_PARAMETER)) == null) {
                string4 = "SET_BASENAME_PARAM";
            }
            this.showStatus("Saving " + string4 + ".draw");
            bl5 = tWikiDraw.post(string5, string4 + ".draw", "text/plain", string6, byteArrayOutputStream.toString(), "TWikiDraw draw file");
            Dimension dimension = new Dimension(0, 0);
            FigureEnumeration figureEnumeration = this.drawing().figuresReverse();
            while (figureEnumeration.hasMoreElements()) {
                Figure figure = figureEnumeration.nextFigure();
                object = figure.displayBox();
                if (((Rectangle)object).x + ((Rectangle)object).width > dimension.width) {
                    dimension.setSize(((Rectangle)object).x + ((Rectangle)object).width, dimension.height);
                }
                if (((Rectangle)object).y + ((Rectangle)object).height <= dimension.height) continue;
                dimension.setSize(dimension.width, ((Rectangle)object).y + ((Rectangle)object).height);
            }
            int n = 10;
            object = this.getApplication().getParameter(BORDERSIZE_PARAMETER);
            if (object != null && (n = Integer.valueOf((String)object).intValue()) < 0) {
                n = 0;
            }
            if ((string3 = this.drawing().getMap()).length() > 0) {
                string2 = string6.substring(0, string6.length() - 5);
                this.showStatus("Saving " + string4 + ".map");
                string3 = "<map name=\"%MAPNAME%\">\n" + string3 + "<area shape=\"rect\" coords=\"" + "0,0," + (dimension.width + n) + "," + n / 2 + "\" href=\"%TWIKIDRAW%\" />\n" + "<area shape=\"rect\" coords=\"" + "0,0," + n / 2 + "," + (dimension.height + n) + "\" href=\"%TWIKIDRAW%\" />\n" + "<area shape=\"rect\" coords=\"" + (dimension.width + n / 2) + ",0," + (dimension.width + n) + "," + (dimension.height + n) + "\" href=\"%TWIKIDRAW%\" />\n" + "<area shape=\"rect\" coords=\"" + "0," + (dimension.height + n / 2) + "," + (dimension.width + n) + "," + (dimension.height + n) + "\" href=\"%TWIKIDRAW%\" />\n" + "</map>";
                bl = tWikiDraw.post(string5, string4 + ".map", "text/plain", string2 + ".map", string3, "TWikiDraw map file");
            } else {
                string2 = string6.substring(0, string6.length() - 5);
                bl = tWikiDraw.post(string5, string4 + ".map", "text/plain", string2 + ".map", "", "");
            }
            string2 = this.getApplication().getParameter(GIFPATH_PARAMETER);
            if (string2 == null || string2.length() == 0) {
                string2 = null;
            }
            if ((string = this.getApplication().getParameter(PNGPATH_PARAMETER)) == null || string.length() == 0) {
                string = null;
            }
            if (string2 != null || string != null) {
                Object object2;
                Object object3;
                this.view().clearSelection();
                Image image = this.view().createImage(dimension.width + n, dimension.height + n);
                Graphics graphics = image.getGraphics();
                this.view().enableGuides(false);
                this.view().drawAll(graphics);
                if (string != null) {
                    this.showStatus("Saving " + string4 + ".png");
                    object3 = new PngEncoderIndexed(image);
                    object2 = ((PngEncoderIndexed)object3).pngEncode();
                    int n2 = ((byte[])object2).length;
                    char[] cArray = new char[n2];
                    for (int i = 0; i < n2; ++i) {
                        cArray[i] = (char)object2[i];
                    }
                    bl2 = tWikiDraw.post(string5, string4 + ".png", "image/png", string, String.valueOf(cArray, 0, n2), "TWikiDraw PNG file");
                }
                if (string2 != null) {
                    this.showStatus("Saving " + string4 + ".gif");
                    object3 = new ByteArrayOutputStream();
                    object2 = new GifEncoder(image, (OutputStream)object3);
                    ((ImageEncoder)object2).encode();
                    byte[] byArray = ((ByteArrayOutputStream)object3).toByteArray();
                    int n3 = ((ByteArrayOutputStream)object3).size();
                    char[] cArray = new char[n3];
                    for (int i = 0; i < n3; ++i) {
                        cArray[i] = (char)byArray[i];
                    }
                    bl3 = tWikiDraw.post(string5, string4 + ".gif", "image/gif", string2, String.valueOf(cArray, 0, n3), "TWikiDraw GIF file");
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            this.setCursor(new Cursor(0));
            this.showStatus("Bad Wiki servlet URL: " + malformedURLException.getMessage());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.setCursor(new Cursor(0));
            this.showStatus(iOException.toString());
        }
        this.setCursor(new Cursor(0));
        this.showStatus("Saved .draw " + (bl5 ? "OK" : "Failed") + " .map " + (bl ? "OK" : "Failed") + " .gif " + (bl3 ? "OK" : "Failed") + " .png " + (bl2 ? "OK" : "Failed"));
        return bl5;
    }

    class ExitDrawingCommand
    extends Command {
        TWikiFrame frame;

        public ExitDrawingCommand(TWikiFrame tWikiFrame2) {
            super("Exit without saving");
            this.frame = tWikiFrame2;
        }

        public void execute() {
            ((TWikiDraw)TWikiFrame.this.getApplication()).exitApplet();
        }
    }

    class SaveDrawingCommand
    extends Command {
        TWikiFrame frame;

        public SaveDrawingCommand(TWikiFrame tWikiFrame2) {
            super("Save and Exit");
            this.frame = tWikiFrame2;
        }

        public void execute() {
            if (this.frame.doSaveDrawing()) {
                ((TWikiDraw)TWikiFrame.this.getApplication()).exitApplet();
            }
        }
    }

    class ReloadDrawingCommand
    extends Command {
        TWikiFrame frame;

        public ReloadDrawingCommand(TWikiFrame tWikiFrame2) {
            super("Reload");
            this.frame = tWikiFrame2;
        }

        public void execute() {
            this.frame.doLoadDrawing(DRAWPATH_PARAMETER);
        }
    }

    class NewDrawingCommand
    extends Command {
        TWikiFrame frame;

        public NewDrawingCommand(TWikiFrame tWikiFrame2) {
            super("Clear");
            this.frame = tWikiFrame2;
        }

        public void execute() {
            this.frame.doLoadDrawing(UNTITLED_PARAMETER);
        }
    }
}

