/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.runtime.binder.vertx;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import io.quarkus.micrometer.runtime.binder.vertx.EventTiming;
import io.vertx.core.spi.metrics.ClientMetrics;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Supplier;

public class VertxClientMetrics
implements ClientMetrics<EventTiming, EventTiming, Object, Object> {
    private final String type;
    private final Timer processing;
    private final LongAdder current = new LongAdder();
    private final LongAdder queue = new LongAdder();
    private final Counter resetCount;
    private final Counter completed;
    private final Timer queueDelay;

    VertxClientMetrics(MeterRegistry registry, String type, Tags tags) {
        this.type = type;
        this.queueDelay = Timer.builder((String)this.name("queue.delay")).description("Time spent in the waiting queue before being processed").tags((Iterable)tags).register(registry);
        this.processing = Timer.builder((String)this.name("processing")).description("Processing time, from request start to response end").tags((Iterable)tags).register(registry);
        Gauge.builder((String)this.name("queue.size"), (Supplier)new Supplier<Number>(){

            @Override
            public Number get() {
                return VertxClientMetrics.this.queue.doubleValue();
            }
        }).description("Number of pending elements in the waiting queue").tags((Iterable)tags).strongReference(true).register(registry);
        Gauge.builder((String)this.name("current"), (Supplier)new Supplier<Number>(){

            @Override
            public Number get() {
                return VertxClientMetrics.this.current.doubleValue();
            }
        }).description("The number of requests currently handled by the client").tags((Iterable)tags).strongReference(true).register(registry);
        this.completed = Counter.builder((String)this.name("completed")).description("Number of requests that have been handled by the client").tags((Iterable)tags).register(registry);
        this.resetCount = Counter.builder((String)this.name("reset")).description("Total number of resets").tags((Iterable)tags).register(registry);
    }

    private String name(String suffix) {
        return this.type + "." + suffix;
    }

    public EventTiming enqueueRequest() {
        this.queue.increment();
        return new EventTiming(this.queueDelay);
    }

    public void dequeueRequest(EventTiming event) {
        this.queue.decrement();
        event.end();
    }

    public EventTiming requestBegin(String uri, Object request) {
        this.current.increment();
        return new EventTiming(this.processing);
    }

    public void requestEnd(EventTiming requestMetric) {
    }

    public void responseBegin(EventTiming requestMetric, Object response) {
    }

    public void requestReset(EventTiming event) {
        this.current.decrement();
        event.end();
        this.resetCount.increment();
    }

    public void responseEnd(EventTiming event) {
        this.current.decrement();
        event.end();
        this.completed.increment();
    }

    public void close() {
    }
}

