/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.polygonize;

import java.util.List;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.index.SpatialIndex;
import org.locationtech.jts.index.strtree.STRtree;
import org.locationtech.jts.operation.polygonize.EdgeRing;

public class HoleAssigner {
    private List<EdgeRing> shells;
    private SpatialIndex shellIndex;

    public static void assignHolesToShells(List holes, List shells) {
        HoleAssigner assigner = new HoleAssigner(shells);
        assigner.assignHolesToShells(holes);
    }

    public HoleAssigner(List<EdgeRing> shells) {
        this.shells = shells;
        this.buildIndex();
    }

    private void buildIndex() {
        this.shellIndex = new STRtree();
        for (EdgeRing shell : this.shells) {
            this.shellIndex.insert(shell.getRing().getEnvelopeInternal(), shell);
        }
    }

    public void assignHolesToShells(List<EdgeRing> holeList) {
        for (EdgeRing holeER : holeList) {
            this.assignHoleToShell(holeER);
        }
    }

    private void assignHoleToShell(EdgeRing holeER) {
        EdgeRing shell = this.findShellContaining(holeER);
        if (shell != null) {
            shell.addHole(holeER);
        }
    }

    private List<EdgeRing> queryOverlappingShells(Envelope ringEnv) {
        return this.shellIndex.query(ringEnv);
    }

    private EdgeRing findShellContaining(EdgeRing testEr) {
        Envelope testEnv = testEr.getRing().getEnvelopeInternal();
        List<EdgeRing> candidateShells = this.queryOverlappingShells(testEnv);
        return EdgeRing.findEdgeRingContaining(testEr, candidateShells);
    }
}

