/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.common.core;

import jakarta.ws.rs.RuntimeType;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.ReaderInterceptor;
import jakarta.ws.rs.ext.WriterInterceptor;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jboss.resteasy.reactive.common.jaxrs.ConfigurationImpl;
import org.jboss.resteasy.reactive.common.model.ResourceReader;
import org.jboss.resteasy.reactive.common.model.ResourceWriter;
import org.jboss.resteasy.reactive.common.util.MediaTypeHelper;
import org.jboss.resteasy.reactive.common.util.QuarkusMultivaluedHashMap;
import org.jboss.resteasy.reactive.common.util.QuarkusMultivaluedMap;

public abstract class Serialisers {
    public static final Annotation[] NO_ANNOTATION = new Annotation[0];
    public static final ReaderInterceptor[] NO_READER_INTERCEPTOR = new ReaderInterceptor[0];
    public static final WriterInterceptor[] NO_WRITER_INTERCEPTOR = new WriterInterceptor[0];
    protected final QuarkusMultivaluedMap<Class<?>, ResourceWriter> writers = new QuarkusMultivaluedHashMap();
    protected final QuarkusMultivaluedMap<Class<?>, ResourceReader> readers = new QuarkusMultivaluedHashMap();

    public List<MessageBodyReader<?>> findReaders(ConfigurationImpl configuration, Class<?> entityType, MediaType mediaType) {
        return this.findReaders(configuration, entityType, mediaType, null);
    }

    public List<MessageBodyReader<?>> findReaders(ConfigurationImpl configuration, Class<?> entityType, MediaType mediaType, RuntimeType runtimeType) {
        QuarkusMultivaluedMap<Class<?>, ResourceReader> readers;
        List<MediaType> desired = MediaTypeHelper.getUngroupedMediaTypes(mediaType);
        ArrayList ret = new ArrayList();
        LinkedList toProcess = new LinkedList();
        Class<Object> klass = this.lookupPrimitiveWrapper(entityType);
        if (configuration != null && !configuration.getResourceReaders().isEmpty()) {
            readers = new QuarkusMultivaluedHashMap();
            readers.addAll(configuration.getResourceReaders());
            readers.addAll(this.readers);
        } else {
            readers = this.readers;
        }
        do {
            Collections.addAll(toProcess, klass.getInterfaces());
            if (klass == Object.class || klass.getSuperclass() == null) {
                HashSet seen = new HashSet(toProcess);
                while (!toProcess.isEmpty()) {
                    Class iface = (Class)toProcess.poll();
                    List goodTypeReaders = (List)readers.get(iface);
                    this.readerLookup(mediaType, runtimeType, desired, ret, goodTypeReaders);
                    for (Class<?> i : iface.getInterfaces()) {
                        if (seen.contains(i)) continue;
                        seen.add(i);
                        toProcess.add(i);
                    }
                }
            }
            List goodTypeReaders = (List)readers.get(klass);
            this.readerLookup(mediaType, runtimeType, desired, ret, goodTypeReaders);
        } while ((klass = klass.isInterface() ? Object.class : klass.getSuperclass()) != null);
        return ret;
    }

    private void readerLookup(MediaType mediaType, RuntimeType runtimeType, List<MediaType> desired, List<MessageBodyReader<?>> ret, List<ResourceReader> goodTypeReaders) {
        if (goodTypeReaders != null && !goodTypeReaders.isEmpty()) {
            int i;
            ArrayList<ResourceReader> mediaTypeMatchingReaders = new ArrayList<ResourceReader>(goodTypeReaders.size());
            for (i = 0; i < goodTypeReaders.size(); ++i) {
                MediaType match;
                ResourceReader goodTypeReader = goodTypeReaders.get(i);
                if (!goodTypeReader.matchesRuntimeType(runtimeType) || (match = MediaTypeHelper.getFirstMatch(desired, goodTypeReader.mediaTypes())) == null && mediaType != null) continue;
                mediaTypeMatchingReaders.add(goodTypeReader);
            }
            mediaTypeMatchingReaders.sort(new ResourceReader.ResourceReaderComparator(Collections.singletonList(mediaType)));
            for (i = 0; i < mediaTypeMatchingReaders.size(); ++i) {
                ResourceReader mediaTypeMatchingReader = (ResourceReader)mediaTypeMatchingReaders.get(i);
                ret.add(mediaTypeMatchingReader.instance());
            }
        }
    }

    public <T> void addWriter(Class<T> entityClass, ResourceWriter writer) {
        this.writers.add(entityClass, writer);
    }

    public <T> void addReader(Class<T> entityClass, ResourceReader reader) {
        this.readers.add(entityClass, reader);
    }

    public List<MessageBodyWriter<?>> findBuildTimeWriters(Class<?> entityType, RuntimeType runtimeType, List<MediaType> produces) {
        if (Response.class.isAssignableFrom(entityType)) {
            return Collections.emptyList();
        }
        Class<?> klass = this.lookupPrimitiveWrapper(entityType);
        for (Map.Entry entry : this.writers.entrySet()) {
            if (!klass.isAssignableFrom((Class)entry.getKey()) || ((Class)entry.getKey()).equals(klass)) continue;
            if (produces == null || produces.isEmpty()) {
                return null;
            }
            List writers = (List)entry.getValue();
            for (int i = 0; i < writers.size(); ++i) {
                MediaType match = MediaTypeHelper.getFirstMatch(produces, ((ResourceWriter)writers.get(i)).mediaTypes());
                if (match == null) continue;
                return null;
            }
        }
        List<ResourceWriter> resourceWriters = this.findResourceWriters(this.writers, klass, produces, runtimeType);
        return this.toMessageBodyWriters(resourceWriters);
    }

    protected List<ResourceWriter> findResourceWriters(QuarkusMultivaluedMap<Class<?>, ResourceWriter> writers, Class<?> klass, List<MediaType> produces, RuntimeType runtimeType) {
        Class<Object> currentClass = klass;
        List<MediaType> desired = MediaTypeHelper.getUngroupedMediaTypes(produces);
        ArrayList<ResourceWriter> ret = new ArrayList<ResourceWriter>();
        LinkedList toProcess = new LinkedList();
        do {
            if (currentClass == Object.class && !toProcess.isEmpty()) {
                HashSet seen = new HashSet(toProcess);
                while (!toProcess.isEmpty()) {
                    Class iface = (Class)toProcess.poll();
                    List goodTypeWriters = (List)writers.get(iface);
                    this.writerLookup(runtimeType, produces, desired, ret, goodTypeWriters);
                    for (Class<?> i : iface.getInterfaces()) {
                        if (seen.contains(i)) continue;
                        seen.add(i);
                        toProcess.add(i);
                    }
                }
            }
            List goodTypeWriters = (List)writers.get(currentClass);
            this.writerLookup(runtimeType, produces, desired, ret, goodTypeWriters);
            Class<?> prevClass = currentClass;
            currentClass = currentClass.isInterface() ? Object.class : currentClass.getSuperclass();
            if (currentClass == null) continue;
            toProcess.addAll(List.of(prevClass.getInterfaces()));
        } while (currentClass != null);
        return ret;
    }

    protected List<MessageBodyWriter<?>> toMessageBodyWriters(List<ResourceWriter> resourceWriters) {
        ArrayList ret = new ArrayList(resourceWriters.size());
        HashSet<Class> alreadySeenClasses = new HashSet<Class>(resourceWriters.size());
        for (int i = 0; i < resourceWriters.size(); ++i) {
            ResourceWriter resourceWriter = resourceWriters.get(i);
            MessageBodyWriter<?> instance = resourceWriter.instance();
            Class instanceClass = instance.getClass();
            if (alreadySeenClasses.contains(instanceClass)) continue;
            ret.add(instance);
            alreadySeenClasses.add(instanceClass);
        }
        return ret;
    }

    private void writerLookup(RuntimeType runtimeType, List<MediaType> produces, List<MediaType> desired, List<ResourceWriter> ret, List<ResourceWriter> goodTypeWriters) {
        if (goodTypeWriters != null && !goodTypeWriters.isEmpty()) {
            ArrayList<ResourceWriter> mediaTypeMatchingWriters = new ArrayList<ResourceWriter>(goodTypeWriters.size());
            for (int i = 0; i < goodTypeWriters.size(); ++i) {
                MediaType match;
                ResourceWriter goodTypeWriter = goodTypeWriters.get(i);
                if (!goodTypeWriter.matchesRuntimeType(runtimeType) || (match = MediaTypeHelper.getFirstMatch(desired, goodTypeWriter.mediaTypes())) == null) continue;
                mediaTypeMatchingWriters.add(goodTypeWriter);
            }
            mediaTypeMatchingWriters.sort(new ResourceWriter.ResourceWriterComparator(produces));
            ret.addAll(mediaTypeMatchingWriters);
        }
    }

    public List<MessageBodyWriter<?>> findWriters(ConfigurationImpl configuration, Class<?> entityType, MediaType resolvedMediaType) {
        return this.findWriters(configuration, entityType, resolvedMediaType, null);
    }

    protected final Class<?> lookupPrimitiveWrapper(Class<?> entityType) {
        if (!entityType.isPrimitive()) {
            return entityType;
        }
        if (entityType == Boolean.TYPE) {
            return Boolean.class;
        }
        if (entityType == Character.TYPE) {
            return Character.class;
        }
        if (entityType == Byte.TYPE) {
            return Byte.class;
        }
        if (entityType == Short.TYPE) {
            return Short.class;
        }
        if (entityType == Integer.TYPE) {
            return Integer.class;
        }
        if (entityType == Long.TYPE) {
            return Long.class;
        }
        if (entityType == Float.TYPE) {
            return Float.class;
        }
        if (entityType == Double.TYPE) {
            return Double.class;
        }
        return entityType;
    }

    public List<MessageBodyWriter<?>> findWriters(ConfigurationImpl configuration, Class<?> entityType, MediaType resolvedMediaType, RuntimeType runtimeType) {
        QuarkusMultivaluedMap<Class<?>, ResourceWriter> writers;
        List<MediaType> mt = Collections.singletonList(resolvedMediaType);
        Class<?> klass = this.lookupPrimitiveWrapper(entityType);
        if (configuration != null && !configuration.getResourceWriters().isEmpty()) {
            writers = new QuarkusMultivaluedHashMap();
            writers.addAll(configuration.getResourceWriters());
            for (Map.Entry writersEntry : this.writers.entrySet()) {
                writers.addAll((Class)writersEntry.getKey(), (List)writersEntry.getValue());
            }
        } else {
            writers = this.writers;
        }
        return this.toMessageBodyWriters(this.findResourceWriters(writers, klass, mt, runtimeType));
    }

    public static class BuiltinReader
    extends Builtin {
        public final Class<? extends MessageBodyReader<?>> readerClass;

        public BuiltinReader(Class<?> entityClass, Class<? extends MessageBodyReader<?>> readerClass, String mediaType) {
            this(entityClass, readerClass, mediaType, null);
        }

        public BuiltinReader(Class<?> entityClass, Class<? extends MessageBodyReader<?>> readerClass, String mediaType, RuntimeType constraint) {
            super(entityClass, mediaType, constraint);
            this.readerClass = readerClass;
        }
    }

    public static class BuiltinWriter
    extends Builtin {
        public final Class<? extends MessageBodyWriter<?>> writerClass;

        public BuiltinWriter(Class<?> entityClass, Class<? extends MessageBodyWriter<?>> writerClass, String mediaType) {
            this(entityClass, writerClass, mediaType, null);
        }

        public BuiltinWriter(Class<?> entityClass, Class<? extends MessageBodyWriter<?>> writerClass, String mediaType, RuntimeType constraint) {
            super(entityClass, mediaType, constraint);
            this.writerClass = writerClass;
        }
    }

    public static class Builtin {
        public final Class<?> entityClass;
        public final String mediaType;
        public final RuntimeType constraint;

        public Builtin(Class<?> entityClass, String mediaType, RuntimeType constraint) {
            this.entityClass = entityClass;
            this.mediaType = mediaType;
            this.constraint = constraint;
        }
    }
}

