/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml.processing.core.parsers.saml.assertion;

import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.StartElement;
import org.keycloak.dom.saml.v2.assertion.EncryptedElementType;
import org.keycloak.dom.saml.v2.assertion.NameIDType;
import org.keycloak.dom.saml.v2.assertion.SubjectConfirmationDataType;
import org.keycloak.dom.saml.v2.assertion.SubjectConfirmationType;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.parsers.StaxParser;
import org.keycloak.saml.common.util.StaxParserUtil;
import org.keycloak.saml.processing.core.parsers.saml.assertion.AbstractStaxSamlAssertionParser;
import org.keycloak.saml.processing.core.parsers.saml.assertion.SAMLAssertionQNames;
import org.keycloak.saml.processing.core.parsers.saml.assertion.SAMLSubjectConfirmationDataParser;
import org.keycloak.saml.processing.core.parsers.util.SAMLParserUtil;
import org.w3c.dom.Element;

public class SAMLSubjectConfirmationParser
extends AbstractStaxSamlAssertionParser<SubjectConfirmationType>
implements StaxParser {
    public static final SAMLSubjectConfirmationParser INSTANCE = new SAMLSubjectConfirmationParser();

    public SAMLSubjectConfirmationParser() {
        super(SAMLAssertionQNames.SUBJECT_CONFIRMATION);
    }

    @Override
    protected SubjectConfirmationType instantiateElement(XMLEventReader xmlEventReader, StartElement element) throws ParsingException {
        SubjectConfirmationType res = new SubjectConfirmationType();
        res.setMethod(StaxParserUtil.getAttributeValue(element, SAMLAssertionQNames.ATTR_METHOD));
        return res;
    }

    @Override
    protected void processSubElement(XMLEventReader xmlEventReader, SubjectConfirmationType target, SAMLAssertionQNames element, StartElement elementDetail) throws ParsingException {
        switch (element) {
            case NAMEID: {
                NameIDType nameID = SAMLParserUtil.parseNameIDType(xmlEventReader);
                target.setNameID(nameID);
                break;
            }
            case ENCRYPTED_ID: {
                Element domElement = StaxParserUtil.getDOMElement(xmlEventReader);
                target.setEncryptedID(new EncryptedElementType(domElement));
                break;
            }
            case SUBJECT_CONFIRMATION_DATA: {
                SubjectConfirmationDataType subjectConfirmationData = (SubjectConfirmationDataType)SAMLSubjectConfirmationDataParser.INSTANCE.parse(xmlEventReader);
                target.setSubjectConfirmationData(subjectConfirmationData);
                break;
            }
            default: {
                throw LOGGER.parserUnknownTag(StaxParserUtil.getElementName(elementDetail), elementDetail.getLocation());
            }
        }
    }
}

