/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.remote.upgrade;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.infinispan.commons.configuration.io.ConfigurationResourceResolvers;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.persistence.remote.configuration.RemoteStoreConfiguration;
import org.infinispan.persistence.remote.configuration.RemoteStoreConfigurationBuilder;

public final class SerializationUtils {
    private static final ParserRegistry parserRegistry = new ParserRegistry();
    private static final String PLACEHOLDER = "cache-holder";

    private SerializationUtils() {
    }

    public static String toJson(RemoteStoreConfiguration configuration) {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        RemoteStoreConfigurationBuilder storeBuilder = (RemoteStoreConfigurationBuilder)builder.persistence().addStore(RemoteStoreConfigurationBuilder.class);
        storeBuilder.read((Object)configuration);
        String stringConfiguration = builder.build().toStringConfiguration(null, MediaType.APPLICATION_JSON, true);
        return Json.read((String)stringConfiguration).at("local-cache").at("persistence").toString();
    }

    public static RemoteStoreConfiguration fromJson(String json) throws IOException {
        ConfigurationBuilderHolder holder = new ConfigurationBuilderHolder();
        holder.newConfigurationBuilder(PLACEHOLDER);
        try (ByteArrayInputStream bais = new ByteArrayInputStream(json.getBytes(StandardCharsets.UTF_8));){
            ConfigurationBuilderHolder parsedHolder = parserRegistry.parse((InputStream)bais, holder, ConfigurationResourceResolvers.DEFAULT, MediaType.APPLICATION_JSON);
            Configuration parsedConfig = ((ConfigurationBuilder)parsedHolder.getNamedConfigurationBuilders().get(PLACEHOLDER)).build();
            RemoteStoreConfiguration remoteStoreConfiguration = (RemoteStoreConfiguration)((Object)parsedConfig.persistence().stores().iterator().next());
            return remoteStoreConfiguration;
        }
    }
}

