/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.vertx.codegen.lang;

import io.smallrye.mutiny.vertx.codegen.lang.CodeGenHelper;
import io.smallrye.mutiny.vertx.codegen.lang.ConditionalCodeWriter;
import io.vertx.codegen.ClassModel;
import io.vertx.codegen.Helper;
import io.vertx.codegen.TypeParamInfo;
import java.io.PrintWriter;
import java.util.List;

public class ConstructorWithDelegateParameterCodeWriter
implements ConditionalCodeWriter {
    private final String constructor;

    public ConstructorWithDelegateParameterCodeWriter(String constructor) {
        this.constructor = constructor;
    }

    public ConstructorWithDelegateParameterCodeWriter() {
        this.constructor = null;
    }

    @Override
    public void generate(ClassModel model, PrintWriter writer) {
        String cst = this.constructor;
        if (cst == null) {
            cst = model.getIfaceSimpleName();
        }
        List typeParams = model.getTypeParams();
        writer.print("  public ");
        writer.print(cst);
        writer.print("(");
        writer.print(Helper.getNonGenericType((String)model.getIfaceFQCN()));
        writer.println(" delegate) {");
        if (model.isConcrete() && CodeGenHelper.hasParentClass(model)) {
            writer.println("    super(delegate);");
        }
        writer.println("    this.delegate = delegate;");
        for (TypeParamInfo.Class typeParam : typeParams) {
            writer.print("    this.__typeArg_");
            writer.print(typeParam.getIndex());
            writer.print(" = io.smallrye.mutiny.vertx.TypeArg.unknown();");
        }
        writer.println("  }");
        writer.println();
    }

    @Override
    public boolean test(ClassModel classModel) {
        return classModel.isConcrete();
    }
}

