/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.cli.command;

import io.quarkus.bootstrap.runner.RunnerClassLoader;
import io.quarkus.runtime.LaunchMode;
import io.smallrye.config.ConfigValue;
import java.util.Optional;
import org.keycloak.config.DatabaseOptions;
import org.keycloak.quarkus.runtime.Environment;
import org.keycloak.quarkus.runtime.Messages;
import org.keycloak.quarkus.runtime.cli.Picocli;
import org.keycloak.quarkus.runtime.cli.command.AbstractCommand;
import org.keycloak.quarkus.runtime.cli.command.DryRunMixin;
import org.keycloak.quarkus.runtime.cli.command.HelpAllMixin;
import org.keycloak.quarkus.runtime.configuration.Configuration;
import org.keycloak.quarkus.runtime.configuration.PersistedConfigSource;
import picocli.CommandLine;

@CommandLine.Command(name="build", header={"Creates a new and optimized server image."}, description={"%nCreates a new and optimized server image based on the configuration options passed to this command. Once created, the configuration will be persisted and read during startup without having to pass them over again.", "", "Consider running this command before running the server in production for an optimal runtime."}, footerHeading="Examples:", footer={"  Change the database vendor:%n%n      $ ${PARENT-COMMAND-FULL-NAME:-$PARENTCOMMAND} ${COMMAND-NAME} --db=postgres%n%n  Enable a feature:%n%n      $ ${PARENT-COMMAND-FULL-NAME:-$PARENTCOMMAND} ${COMMAND-NAME} --features=<feature_name>%n%n  Or alternatively, enable all tech preview features:%n%n      $ ${PARENT-COMMAND-FULL-NAME:-$PARENTCOMMAND} ${COMMAND-NAME} --features=preview%n%n  Enable health endpoints:%n%n      $ ${PARENT-COMMAND-FULL-NAME:-$PARENTCOMMAND} ${COMMAND-NAME} --health-enabled=true%n%n  Enable metrics endpoints:%n%n      $ ${PARENT-COMMAND-FULL-NAME:-$PARENTCOMMAND} ${COMMAND-NAME} --metrics-enabled=true%n%n  Change the relative path:%n%n      $ ${PARENT-COMMAND-FULL-NAME:-$PARENTCOMMAND} ${COMMAND-NAME} --http-relative-path=/auth%n"})
public final class Build
extends AbstractCommand
implements Runnable {
    public static final String NAME = "build";
    @CommandLine.Mixin
    HelpAllMixin helpAllMixin;
    @CommandLine.Mixin
    DryRunMixin dryRunMixin;

    @Override
    public void run() {
        if (org.keycloak.common.util.Environment.getProfile() == null) {
            Environment.setProfile("prod");
        }
        this.checkProfileAndDb();
        PersistedConfigSource.getInstance().runWithDisabled(() -> {
            this.validateConfig();
            return null;
        });
        Environment.setRebuild();
        Picocli.println(this.spec.commandLine(), "Updating the configuration and installing your custom providers, if any. Please wait.");
        try {
            Build.configureBuildClassLoader();
            this.beforeReaugmentationOnWindows();
            if (!Boolean.TRUE.equals(this.dryRunMixin.dryRun)) {
                this.picocli.build();
            } else if (DryRunMixin.isDryRunBuild()) {
                PersistedConfigSource.getInstance().saveDryRunProperties();
            }
            if (!Environment.isDevProfile()) {
                Picocli.println(this.spec.commandLine(), "Server configuration updated and persisted. Run the following command to review the configuration:\n");
                Picocli.println(this.spec.commandLine(), "\t" + Environment.getCommand() + " show-config\n");
            }
        }
        catch (Throwable throwable) {
            this.executionError(this.spec.commandLine(), "Failed to update server configuration.", throwable);
        }
        finally {
            this.cleanTempResources();
        }
    }

    private static void configureBuildClassLoader() {
        Optional.ofNullable(Configuration.getNonPersistedConfigValue("quarkus.class-loading.removed-artifacts")).map(ConfigValue::getValue).ifPresent(s -> System.setProperty("quarkus.class-loading.removed-artifacts", s));
    }

    @Override
    public boolean includeBuildTime() {
        return true;
    }

    private void checkProfileAndDb() {
        if (Environment.isDevProfile()) {
            String cmd = Environment.getParsedCommand().map(AbstractCommand::getName).orElse(this.getName());
            if ("start".equals(cmd) || NAME.equals(cmd)) {
                this.executionError(this.spec.commandLine(), Messages.devProfileNotAllowedError(cmd));
            }
        } else if (Configuration.getConfigValue(DatabaseOptions.DB).getConfigSourceOrdinal() == 0) {
            this.picocli.warn("Usage of the default value for the db option in the production profile is deprecated. Please explicitly set the db instead.");
        }
    }

    private void beforeReaugmentationOnWindows() {
        ClassLoader classLoader;
        if (Environment.isWindows() && (classLoader = Thread.currentThread().getContextClassLoader()) instanceof RunnerClassLoader) {
            ((RunnerClassLoader)classLoader).resetInternalCaches();
        }
    }

    private void cleanTempResources() {
        if (!LaunchMode.current().isDevOrTest()) {
            Optional.ofNullable(Environment.getHomePath()).ifPresent(path -> path.resolve("quarkus-artifact.properties").toFile().delete());
        }
    }

    @Override
    public String getName() {
        return NAME;
    }
}

