/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.executor;

import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.representations.idm.ClientPolicyExecutorConfigurationRepresentation;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyEvent;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.context.TokenRefreshResponseContext;
import org.keycloak.services.clientpolicy.executor.ClientPolicyExecutorProvider;

public class SuppressRefreshTokenRotationExecutor
implements ClientPolicyExecutorProvider<ClientPolicyExecutorConfigurationRepresentation> {
    private static final Logger logger = Logger.getLogger(SuppressRefreshTokenRotationExecutor.class);
    protected final KeycloakSession session;

    public SuppressRefreshTokenRotationExecutor(KeycloakSession session) {
        this.session = session;
    }

    public String getProviderId() {
        return "suppress-refresh-token-rotation";
    }

    public void executeOnEvent(ClientPolicyContext context) throws ClientPolicyException {
        ClientPolicyEvent event = context.getEvent();
        logger.tracev("Client Policy Trigger Event = {0}", (Object)event);
        switch (event) {
            case TOKEN_REFRESH_RESPONSE: {
                TokenRefreshResponseContext tokenRefreshResponseContext = (TokenRefreshResponseContext)context;
                TokenManager.AccessTokenResponseBuilder builder = tokenRefreshResponseContext.getAccessTokenResponseBuilder();
                builder.refreshToken(null);
                logger.trace((Object)"A rorated refresh token was suppressed.");
                break;
            }
            default: {
                return;
            }
        }
    }
}

