/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.executor;

import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oidc.endpoints.request.AuthorizationEndpointRequest;
import org.keycloak.protocol.oidc.utils.OIDCResponseType;
import org.keycloak.representations.idm.ClientPolicyExecutorConfigurationRepresentation;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.context.AuthorizationRequestContext;
import org.keycloak.services.clientpolicy.executor.ClientPolicyExecutorProvider;
import org.keycloak.util.TokenUtil;

public class SecureSessionEnforceExecutor
implements ClientPolicyExecutorProvider<ClientPolicyExecutorConfigurationRepresentation> {
    private static final Logger logger = Logger.getLogger(SecureSessionEnforceExecutor.class);
    private final KeycloakSession session;

    public SecureSessionEnforceExecutor(KeycloakSession session) {
        this.session = session;
    }

    public String getProviderId() {
        return "secure-session";
    }

    public void executeOnEvent(ClientPolicyContext context) throws ClientPolicyException {
        switch (context.getEvent()) {
            case AUTHORIZATION_REQUEST: {
                AuthorizationRequestContext authorizationRequestContext = (AuthorizationRequestContext)context;
                this.executeOnAuthorizationRequest(authorizationRequestContext.getparsedResponseType(), authorizationRequestContext.getAuthorizationEndpointRequest(), authorizationRequestContext.getRedirectUri());
                return;
            }
        }
    }

    private void executeOnAuthorizationRequest(OIDCResponseType parsedResponseType, AuthorizationEndpointRequest request, String redirectUri) throws ClientPolicyException {
        logger.trace((Object)"Authz Endpoint - authz request");
        if (TokenUtil.isOIDCRequest((String)request.getScope())) {
            if (request.getNonce() == null) {
                logger.trace((Object)"Missing parameter: nonce");
                throw new ClientPolicyException("invalid_request", "Missing parameter: nonce");
            }
        } else if (request.getState() == null) {
            logger.trace((Object)"Missing parameter: state");
            throw new ClientPolicyException("invalid_request", "Missing parameter: state");
        }
        logger.trace((Object)"Passed.");
    }
}

