/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.keys;

import java.util.stream.Stream;
import javax.crypto.SecretKey;
import org.keycloak.common.util.Base64Url;
import org.keycloak.common.util.KeyUtils;
import org.keycloak.component.ComponentModel;
import org.keycloak.crypto.JavaAlgorithm;
import org.keycloak.crypto.KeyStatus;
import org.keycloak.crypto.KeyUse;
import org.keycloak.crypto.KeyWrapper;
import org.keycloak.keys.KeyProvider;

public abstract class AbstractGeneratedSecretKeyProvider
implements KeyProvider {
    private final KeyStatus status;
    private final ComponentModel model;
    private final String kid;
    private final SecretKey secretKey;
    private final KeyUse use;
    private String type;
    private final String algorithm;

    public AbstractGeneratedSecretKeyProvider(ComponentModel model, KeyUse use, String type, String algorithm) {
        this.status = KeyStatus.from((boolean)model.get("active", true), (boolean)model.get("enabled", true));
        this.kid = model.get("kid");
        this.model = model;
        this.use = use;
        this.type = type;
        this.algorithm = algorithm;
        if (model.hasNote(SecretKey.class.getName())) {
            this.secretKey = (SecretKey)model.getNote(SecretKey.class.getName());
        } else {
            this.secretKey = KeyUtils.loadSecretKey((byte[])Base64Url.decode((String)model.get("secret")), (String)JavaAlgorithm.getJavaAlgorithm((String)algorithm));
            model.setNote(SecretKey.class.getName(), (Object)this.secretKey);
        }
    }

    public Stream<KeyWrapper> getKeysStream() {
        KeyWrapper key = new KeyWrapper();
        key.setProviderId(this.model.getId());
        key.setProviderPriority(this.model.get("priority", 0L));
        key.setKid(this.kid);
        key.setUse(this.use);
        key.setType(this.type);
        key.setAlgorithm(this.algorithm);
        key.setStatus(this.status);
        key.setSecretKey(this.secretKey);
        return Stream.of(key);
    }

    public void close() {
    }
}

