/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.common.processor.transformation;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.function.Predicate;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationTransformation;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.resteasy.reactive.common.processor.transformation.AnnotationsTransformation;

public final class Transformation
implements AnnotationsTransformation<Transformation> {
    private final AnnotationTransformation.TransformationContext ctx;
    private final Collection<AnnotationInstance> modifiedAnnotations;

    Transformation(AnnotationTransformation.TransformationContext ctx) {
        this.ctx = ctx;
        this.modifiedAnnotations = new HashSet<AnnotationInstance>(ctx.annotations());
    }

    @Override
    public Transformation add(AnnotationInstance annotation) {
        this.modifiedAnnotations.add(annotation);
        return this;
    }

    @Override
    public Transformation addAll(Collection<AnnotationInstance> annotations) {
        this.modifiedAnnotations.addAll(annotations);
        return this;
    }

    @Override
    public Transformation addAll(AnnotationInstance ... annotations) {
        Collections.addAll(this.modifiedAnnotations, annotations);
        return this;
    }

    @Override
    public Transformation add(Class<? extends Annotation> annotationType, AnnotationValue ... values) {
        this.add(DotName.createSimple((String)annotationType.getName()), values);
        return this;
    }

    @Override
    public Transformation add(DotName name, AnnotationValue ... values) {
        this.add(AnnotationInstance.create((DotName)name, (AnnotationTarget)this.ctx.declaration(), (AnnotationValue[])values));
        return this;
    }

    @Override
    public Transformation remove(Predicate<AnnotationInstance> predicate) {
        this.modifiedAnnotations.removeIf(predicate);
        return this;
    }

    @Override
    public Transformation removeAll() {
        this.modifiedAnnotations.clear();
        return this;
    }

    @Override
    public void done() {
        this.ctx.removeAll();
        this.ctx.addAll(this.modifiedAnnotations);
    }
}

