/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.infinispan.remote;

import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.impl.InternalRemoteCache;
import org.infinispan.client.hotrod.impl.operations.PingResponse;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.util.concurrent.ActionSequencer;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.common.util.MultiSiteUtils;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.health.LoadBalancerCheckProvider;
import org.keycloak.health.LoadBalancerCheckProviderFactory;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.EnvironmentDependentProviderFactory;
import org.keycloak.provider.Provider;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;

public class RemoteLoadBalancerCheckProviderFactory
implements LoadBalancerCheckProviderFactory,
EnvironmentDependentProviderFactory {
    private static final int DEFAULT_POLL_INTERVAL = 5000;
    private static final LoadBalancerCheckProvider ALWAYS_HEALTHY = () -> false;
    private static final Logger logger = Logger.getLogger(MethodHandles.lookup().lookupClass());
    private volatile int pollIntervalMillis;
    private volatile LoadBalancerCheckProvider provider;
    private InfinispanConnectionProvider connectionProvider;
    private ScheduledFuture<?> availabilityFuture;
    private RemoteCacheCheckList remoteCacheCheckList;

    public boolean isSupported(Config.Scope config) {
        return MultiSiteUtils.isMultiSiteEnabled();
    }

    public LoadBalancerCheckProvider create(KeycloakSession session) {
        return this.provider;
    }

    public void init(Config.Scope config) {
        this.pollIntervalMillis = config.getInt("poll-interval", Integer.valueOf(5000));
    }

    public void postInit(KeycloakSessionFactory factory) {
        try (KeycloakSession session = factory.create();){
            InfinispanConnectionProvider provider = (InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class);
            if (provider == null) {
                logger.warn((Object)"InfinispanConnectionProvider is not available. Load balancer check will be always healthy for Infinispan.");
                this.provider = ALWAYS_HEALTHY;
                return;
            }
            this.connectionProvider = provider;
            List<RemoteCacheCheck> remoteCacheChecks = InfinispanConnectionProvider.skipSessionsCacheIfRequired(Arrays.stream(InfinispanConnectionProvider.CLUSTERED_CACHE_NAMES)).map(s -> new RemoteCacheCheck((String)s, provider)).collect(Collectors.toList());
            ActionSequencer sequencer = new ActionSequencer(this.connectionProvider.getExecutor("load-balancer-check"), false, null);
            this.remoteCacheCheckList = new RemoteCacheCheckList(remoteCacheChecks, sequencer);
            this.availabilityFuture = provider.getScheduledExecutor().scheduleAtFixedRate(this.remoteCacheCheckList, this.pollIntervalMillis, this.pollIntervalMillis, TimeUnit.MILLISECONDS);
            this.provider = this::isAnyCacheDown;
        }
    }

    public void close() {
        if (this.availabilityFuture != null) {
            this.availabilityFuture.cancel(true);
            this.availabilityFuture = null;
        }
        this.provider = null;
        this.remoteCacheCheckList = null;
    }

    public String getId() {
        return "remote";
    }

    public int order() {
        return 1;
    }

    public Set<Class<? extends Provider>> dependsOn() {
        return Set.of(InfinispanConnectionProvider.class);
    }

    public List<ProviderConfigProperty> getConfigMetadata() {
        return ProviderConfigurationBuilder.create().property().name("poll-interval").type("int").helpText("The Remote caches poll interval, in milliseconds, for connection availability").defaultValue((Object)5000).add().build();
    }

    private boolean isAnyCacheDown() {
        return this.isEmbeddedCachesDown() || this.remoteCacheCheckList.isDown();
    }

    private boolean isEmbeddedCachesDown() {
        for (String name : InfinispanConnectionProvider.LOCAL_CACHE_NAMES) {
            Cache cache = this.connectionProvider.getCache(name, false);
            if (cache == null || !cache.getStatus().allowInvocations()) {
                logger.debugf("Cache '%s' is not started yet.", (Object)name);
                return true;
            }
            PersistenceManager persistenceManager = (PersistenceManager)ComponentRegistry.componentOf(cache, PersistenceManager.class);
            if (persistenceManager == null || persistenceManager.isAvailable()) continue;
            logger.debugf("Persistence for embedded cache '%s' is down.", (Object)name);
            return true;
        }
        return false;
    }

    private record RemoteCacheCheckList(List<RemoteCacheCheck> list, ActionSequencer sequencer) implements Runnable
    {
        @Override
        public void run() {
            this.list.forEach(remoteCacheCheck -> this.sequencer.orderOnKey((Object)remoteCacheCheck.name(), (Callable)remoteCacheCheck));
        }

        public boolean isDown() {
            return this.list.stream().anyMatch(RemoteCacheCheck::isDown);
        }
    }

    private static class RemoteCacheCheck
    implements Callable<CompletionStage<Void>>,
    BiFunction<PingResponse, Throwable, Void> {
        private final String name;
        private final InfinispanConnectionProvider provider;
        private volatile boolean isDown;

        private RemoteCacheCheck(String name, InfinispanConnectionProvider provider) {
            this.name = name;
            this.provider = provider;
        }

        String name() {
            return this.name;
        }

        boolean isDown() {
            return this.isDown;
        }

        @Override
        public CompletionStage<Void> call() {
            try {
                RemoteCache cache = this.provider.getRemoteCache(this.name);
                if (cache instanceof InternalRemoteCache) {
                    return ((InternalRemoteCache)cache).ping().handle(this);
                }
                this.isDown = false;
            }
            catch (Exception e) {
                if (!this.isDown) {
                    logger.warnf("Remote cache '%' is down.", (Object)this.name);
                }
                this.isDown = true;
            }
            return CompletableFutures.completedNull();
        }

        @Override
        public Void apply(PingResponse response, Throwable throwable) {
            boolean successPing = response != null && response.isSuccess();
            logger.debugf("Received Ping response for cache '%s'. Success=%s, Throwable=%s", (Object)this.name, (Object)successPing, (Object)throwable);
            this.isDown = throwable != null || !successPing;
            return null;
        }
    }
}

