/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.jose.jwe;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.keycloak.jose.JOSEHeader;
import org.keycloak.jose.jwk.ECPublicJWK;

@JsonIgnoreProperties(ignoreUnknown=true)
public class JWEHeader
implements JOSEHeader {
    @JsonProperty(value="alg")
    private String algorithm;
    @JsonProperty(value="enc")
    private String encryptionAlgorithm;
    @JsonProperty(value="zip")
    private String compressionAlgorithm;
    @JsonProperty(value="typ")
    private String type;
    @JsonProperty(value="cty")
    private String contentType;
    @JsonProperty(value="kid")
    private String keyId;
    @JsonProperty(value="epk")
    private ECPublicJWK ephemeralPublicKey;
    @JsonProperty(value="apu")
    private String agreementPartyUInfo;
    @JsonProperty(value="apv")
    private String agreementPartyVInfo;
    private static final ObjectMapper mapper = new ObjectMapper();

    public JWEHeader() {
    }

    public JWEHeader(String algorithm, String encryptionAlgorithm, String compressionAlgorithm) {
        this.algorithm = algorithm;
        this.encryptionAlgorithm = encryptionAlgorithm;
        this.compressionAlgorithm = compressionAlgorithm;
    }

    public JWEHeader(String algorithm, String encryptionAlgorithm, String compressionAlgorithm, String keyId) {
        this.algorithm = algorithm;
        this.encryptionAlgorithm = encryptionAlgorithm;
        this.compressionAlgorithm = compressionAlgorithm;
        this.keyId = keyId;
    }

    public JWEHeader(String algorithm, String encryptionAlgorithm, String compressionAlgorithm, String keyId, String contentType) {
        this.algorithm = algorithm;
        this.encryptionAlgorithm = encryptionAlgorithm;
        this.compressionAlgorithm = compressionAlgorithm;
        this.keyId = keyId;
        this.contentType = contentType;
    }

    public JWEHeader(String algorithm, String encryptionAlgorithm, String compressionAlgorithm, String keyId, String contentType, String type, ECPublicJWK ephemeralPublicKey, String agreementPartyUInfo, String agreementPartyVInfo) {
        this.algorithm = algorithm;
        this.encryptionAlgorithm = encryptionAlgorithm;
        this.compressionAlgorithm = compressionAlgorithm;
        this.keyId = keyId;
        this.type = type;
        this.contentType = contentType;
        this.ephemeralPublicKey = ephemeralPublicKey;
        this.agreementPartyUInfo = agreementPartyUInfo;
        this.agreementPartyVInfo = agreementPartyVInfo;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    @JsonIgnore
    public String getRawAlgorithm() {
        return this.getAlgorithm();
    }

    public String getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public String getCompressionAlgorithm() {
        return this.compressionAlgorithm;
    }

    public String getType() {
        return this.type;
    }

    public String getContentType() {
        return this.contentType;
    }

    @Override
    public String getKeyId() {
        return this.keyId;
    }

    public ECPublicJWK getEphemeralPublicKey() {
        return this.ephemeralPublicKey;
    }

    public String getAgreementPartyUInfo() {
        return this.agreementPartyUInfo;
    }

    public String getAgreementPartyVInfo() {
        return this.agreementPartyVInfo;
    }

    public String toString() {
        try {
            return mapper.writeValueAsString((Object)this);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public JWEHeaderBuilder toBuilder() {
        return JWEHeader.builder().algorithm(this.algorithm).encryptionAlgorithm(this.encryptionAlgorithm).compressionAlgorithm(this.compressionAlgorithm).type(this.type).contentType(this.contentType).keyId(this.keyId).ephemeralPublicKey(this.ephemeralPublicKey).agreementPartyUInfo(this.agreementPartyUInfo).agreementPartyVInfo(this.agreementPartyVInfo);
    }

    public static JWEHeaderBuilder builder() {
        return new JWEHeaderBuilder();
    }

    static {
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    public static class JWEHeaderBuilder {
        private String algorithm = null;
        private String encryptionAlgorithm = null;
        private String compressionAlgorithm = null;
        private String type = null;
        private String contentType = null;
        private String keyId = null;
        private ECPublicJWK ephemeralPublicKey = null;
        private String agreementPartyUInfo = null;
        private String agreementPartyVInfo = null;

        public JWEHeaderBuilder algorithm(String algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        public JWEHeaderBuilder encryptionAlgorithm(String encryptionAlgorithm) {
            this.encryptionAlgorithm = encryptionAlgorithm;
            return this;
        }

        public JWEHeaderBuilder compressionAlgorithm(String compressionAlgorithm) {
            this.compressionAlgorithm = compressionAlgorithm;
            return this;
        }

        public JWEHeaderBuilder type(String type) {
            this.type = type;
            return this;
        }

        public JWEHeaderBuilder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public JWEHeaderBuilder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public JWEHeaderBuilder ephemeralPublicKey(ECPublicJWK ephemeralPublicKey) {
            this.ephemeralPublicKey = ephemeralPublicKey;
            return this;
        }

        public JWEHeaderBuilder agreementPartyUInfo(String agreementPartyUInfo) {
            this.agreementPartyUInfo = agreementPartyUInfo;
            return this;
        }

        public JWEHeaderBuilder agreementPartyVInfo(String agreementPartyVInfo) {
            this.agreementPartyVInfo = agreementPartyVInfo;
            return this;
        }

        public JWEHeader build() {
            return new JWEHeader(this.algorithm, this.encryptionAlgorithm, this.compressionAlgorithm, this.keyId, this.contentType, this.type, this.ephemeralPublicKey, this.agreementPartyUInfo, this.agreementPartyVInfo);
        }
    }
}

