/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tracing;

import org.keycloak.Config;
import org.keycloak.common.Profile;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.tracing.NoopTracingProvider;
import org.keycloak.tracing.TracingProvider;
import org.keycloak.tracing.TracingProviderFactory;

public class NoopTracingProviderFactory
implements TracingProviderFactory {
    public static final String PROVIDER_ID = "noop";
    private static TracingProvider SINGLETON;

    public TracingProvider create(KeycloakSession session) {
        if (SINGLETON == null) {
            SINGLETON = new NoopTracingProvider();
        }
        return SINGLETON;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
        SINGLETON = null;
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public int order() {
        return !Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.OPENTELEMETRY) ? 1000 : -1000;
    }

    @Override
    public boolean isSupported(Config.Scope config) {
        return true;
    }
}

