/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models;

import java.util.Arrays;
import java.util.Collection;
import java.util.regex.Pattern;

public final class Constants {
    public static final String ADMIN_CONSOLE_CLIENT_ID = "security-admin-console";
    public static final String ADMIN_CLI_CLIENT_ID = "admin-cli";
    public static final String ACCOUNT_MANAGEMENT_CLIENT_ID = "account";
    public static final String ACCOUNT_CONSOLE_CLIENT_ID = "account-console";
    public static final String BROKER_SERVICE_CLIENT_ID = "broker";
    public static final String REALM_MANAGEMENT_CLIENT_ID = "realm-management";
    public static final String AUTH_BASE_URL_PROP = "${authBaseUrl}";
    public static final String AUTH_ADMIN_URL_PROP = "${authAdminUrl}";
    public static final Collection<String> defaultClients = Arrays.asList("account", "admin-cli", "broker", "realm-management", "security-admin-console");
    public static final String INSTALLED_APP_URN = "urn:ietf:wg:oauth:2.0:oob";
    public static final String READ_TOKEN_ROLE = "read-token";
    public static final String[] BROKER_SERVICE_ROLES = new String[]{"read-token"};
    public static final String OFFLINE_ACCESS_ROLE = "offline_access";
    public static final String DEFAULT_ROLES_ROLE_PREFIX = "default-roles";
    public static final String AUTHZ_UMA_PROTECTION = "uma_protection";
    public static final String AUTHZ_UMA_AUTHORIZATION = "uma_authorization";
    public static final String[] AUTHZ_DEFAULT_AUTHORIZATION_ROLES = new String[]{"uma_authorization"};
    public static final int DEFAULT_ACCESS_TOKEN_LIFESPAN_FOR_IMPLICIT_FLOW_TIMEOUT = 900;
    public static final int DEFAULT_OFFLINE_SESSION_IDLE_TIMEOUT = 2592000;
    public static final int DEFAULT_OFFLINE_SESSION_MAX_LIFESPAN = 5184000;
    public static final String DEFAULT_SIGNATURE_ALGORITHM = "RS256";
    public static final String INTERNAL_SIGNATURE_ALGORITHM = "HS512";
    public static final int DEFAULT_SESSION_IDLE_TIMEOUT = 1800;
    public static final int DEFAULT_SESSION_MAX_LIFESPAN = 36000;
    public static final String DEFAULT_WEBAUTHN_POLICY_SIGNATURE_ALGORITHMS = "ES256,RS256";
    public static final String DEFAULT_WEBAUTHN_POLICY_RP_ENTITY_NAME = "keycloak";
    public static final String DEFAULT_WEBAUTHN_POLICY_NOT_SPECIFIED = "not specified";
    public static final String WEBAUTHN_PASSWORDLESS_PREFIX = "Passwordless";
    public static final String VERIFY_EMAIL_KEY = "VERIFY_EMAIL_KEY";
    public static final String EXECUTION = "execution";
    public static final String CLIENT_ID = "client_id";
    public static final String TOKEN = "token";
    public static final String TAB_ID = "tab_id";
    public static final String CLIENT_DATA = "client_data";
    public static final String REUSE_ID = "reuse_id";
    public static final String SKIP_LOGOUT = "skip_logout";
    public static final String KEY = "key";
    public static final String KC_ACTION = "kc_action";
    public static final String KC_ACTION_PARAMETER = "kc_action_parameter";
    public static final String KC_ACTION_PARAMETER_SKIP_IF_EXISTS = "skip_if_exists";
    public static final String KC_ACTION_STATUS = "kc_action_status";
    public static final String KC_ACTION_EXECUTING = "kc_action_executing";
    public static final String KC_ACTION_ENFORCED = "kc_action_enforced";
    public static final int KC_ACTION_MAX_AGE = 300;
    public static final String MAX_AUTH_AGE_KEY = "max_auth_age";
    public static final String IS_AIA_REQUEST = "IS_AIA_REQUEST";
    public static final String AIA_SILENT_CANCEL = "silent_cancel";
    public static final String AUTHENTICATION_EXECUTION = "authenticationExecution";
    public static final String CREDENTIAL_ID = "credentialId";
    public static final String SKIP_LINK = "skipLink";
    public static final String TEMPLATE_ATTR_ACTION_URI = "actionUri";
    public static final String TEMPLATE_ATTR_REQUIRED_ACTIONS = "requiredActions";
    public static final String IGNORE_ACCEPT_LANGUAGE_HEADER = "IGNORE_ACCEPT_LANGUAGE_HEADER";
    public static final String USER_ATTRIBUTES_PREFIX = "user.attributes.";
    public static final String MAPPER_GRANTED_ROLES = "MAPPER_GRANTED_ROLES";
    public static final String MAPPER_GRANTED_GROUPS = "MAPPER_GRANTED_GROUPS";
    public static final String MAPPER_SESSION_NOTES = "MAPPER_SESSION_NOTES";
    public static final String GENERATE = "GENERATE";
    public static final int DEFAULT_MAX_RESULTS = 100;
    public static final String CFG_DELIMITER = "##";
    public static final Pattern CFG_DELIMITER_PATTERN = Pattern.compile("\\s*##\\s*");
    public static final String OFFLINE_ACCESS_SCOPE_CONSENT_TEXT = "${offlineAccessScopeConsentText}";
    public static final String STORAGE_BATCH_ENABLED = "org.keycloak.storage.batch_enabled";
    public static final String STORAGE_BATCH_SIZE = "org.keycloak.storage.batch_size";
    public static final String SNAPSHOT_VERSION = "999.0.0-SNAPSHOT";
    public static final String CLIENT_PROFILES = "client-policies.profiles";
    public static final String CLIENT_POLICIES = "client-policies.policies";
    public static final String LEVEL_OF_AUTHENTICATION = "level-of-authentication";
    public static final String AUTHENTICATION_EXECUTION_REFERENCE_VALUE = "default.reference.value";
    public static final String AUTHENTICATION_EXECUTION_REFERENCE_MAX_AGE = "default.reference.maxAge";
    public static final String AUTHENTICATORS_COMPLETED = "authenticators-completed";
    public static final String LOA_MAP = "loa-map";
    public static final String REQUESTED_LEVEL_OF_AUTHENTICATION = "requested-level-of-authentication";
    public static final String FORCE_LEVEL_OF_AUTHENTICATION = "force-level-of-authentication";
    public static final String ACR_LOA_MAP = "acr.loa.map";
    public static final String DEFAULT_ACR_VALUES = "default.acr.values";
    public static final String MINIMUM_ACR_VALUE = "minimum.acr.value";
    public static final int MINIMUM_LOA = 0;
    public static final int NO_LOA = -1;
    public static final String SESSION_NOTE_LIGHTWEIGHT_USER = "keycloak.userModel";
    public static final String USE_LIGHTWEIGHT_ACCESS_TOKEN_ENABLED = "client.use.lightweight.access.token.enabled";
    public static final String SUPPORT_JWT_CLAIM_IN_INTROSPECTION_RESPONSE_ENABLED = "client.introspection.response.allow.jwt.claim.enabled";
    public static final String TOTP_SECRET_KEY = "TOTP_SECRET_KEY";
    public static final String AUTHENTICATION_EXPIRED_MESSAGE = "authentication_expired";
    public static final String SECURITY_ADMIN_CONSOLE_ATTR = "security.admin.console";
    public static final String REALM_CLIENT = "realm_client";
    public static final String ADMIN_PERMISSIONS_CLIENT_ID = "admin-permissions";
    public static final String REQUESTED_AUTHENTICATION_FLOW = "requested-authentication-flow";
    public static final String AUTHENTICATION_FLOW_LEVEL_OF_AUTHENTICATION = "authentication-flow-level-of-authentication";
    public static final String CLIENT_POLICY_REQUESTED_ACR = "client-policy-requested-acr";
    public static final String REQUESTED_AUDIENCE_CLIENTS = "req-aud-clients";
    public static final String REQUESTED_AUDIENCE = "req-aud";
    public static final String GRANT_TYPE = "grant_type";
    public static final String TOKEN_EXCHANGE_SUBJECT_CLIENT = "token_exchange_subject_client";
    public static final String CREATED_FROM_PERSISTENT = "created_from_persistent";
    public static final String CREATED_FROM_PERSISTENT_ONLINE = "online";
    public static final String CREATED_FROM_PERSISTENT_OFFLINE = "offline";
}

